/*
 * Decompiled with CFR 0.152.
 */
package com.slimpay;

import com.slimpay.Config;
import com.slimpay.Exception.HttpException;
import com.slimpay.Exception.RequestDataException;
import com.slimpay.Link;
import com.slimpay.RequestMethod;
import com.slimpay.Token;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.CharsetUtils;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    private static final Logger LOGGER = Config.getLogger();
    protected static CloseableHttpClient client;
    protected static Token token;
    protected CloseableHttpResponse response;
    protected String entityContent;

    protected Resource() {
    }

    protected Resource(CloseableHttpResponse response) throws Exception {
        this.setResponse(response);
    }

    public CloseableHttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(CloseableHttpResponse response) throws Exception {
        this.response = response;
        HttpEntity entity = response.getEntity();
        this.entityContent = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
    }

    public String getBodyAsString() {
        return this.entityContent;
    }

    public JSONObject getBodyAsJson() {
        try {
            return this.entityContent == null ? null : new JSONObject(this.entityContent);
        }
        catch (JSONException ex) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Unparsable response body: " + this.entityContent);
            }
            return null;
        }
    }

    public JSONObject getLinks() {
        JSONObject body = new JSONObject(this.getBodyAsString());
        JSONObject links = new JSONObject();
        if (body.has("_links")) {
            JSONObject _links = body.getJSONObject("_links");
            Iterator keys = _links.keys();
            while (keys.hasNext()) {
                String rel = (String)keys.next();
                JSONObject attributes = (JSONObject)_links.get(rel);
                links.put(rel, (Object)new Link(rel, attributes));
            }
        }
        return links;
    }

    public Link getLink(String rel) {
        return this.getLink(rel, false);
    }

    public Link getLink(String rel, boolean strict) {
        JSONObject links = this.getLinks();
        if (links == null || links.length() == 0) {
            return null;
        }
        Iterator keys = links.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.equals(rel) && (strict || !key.endsWith("#" + rel))) continue;
            return (Link)links.get(key);
        }
        return null;
    }

    public Resource follow(RequestMethod method, String rel) throws Exception, RequestDataException, HttpException {
        return this.follow(method, rel, null, null);
    }

    public Resource follow(RequestMethod method, String rel, JSONObject data) throws Exception, RequestDataException, HttpException {
        return this.follow(method, rel, (HttpEntity)Resource.jsonToEntity(data), "json");
    }

    public Resource follow(RequestMethod method, String rel, Map<String, String> data) throws Exception, RequestDataException, HttpException {
        return this.follow(method, rel, (HttpEntity)Resource.mapToEntity(data), "urlencoded");
    }

    public Resource follow(RequestMethod method, String rel, String data) throws Exception, RequestDataException, HttpException {
        return this.follow(method, rel, (HttpEntity)Resource.stringToEntity(data), "urlencoded");
    }

    public Resource follow(RequestMethod method, String rel, HttpEntity data, String format) throws Exception, RequestDataException, HttpException {
        Link link;
        Resource.oauth();
        if (LOGGER.isLoggable(Level.INFO)) {
            if (data == null) {
                LOGGER.info("Following relation: " + rel + " without data");
            } else {
                LOGGER.info("Following relation: " + rel + " with data (format: " + format + ")");
            }
        }
        if ((link = this.getLink(rel)) == null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("No link found for relation: " + rel);
            }
            return null;
        }
        return Resource.request(method, link.getAttribute("href"), data, format);
    }

    public static Resource request(RequestMethod method, String url) throws Exception, RequestDataException, HttpException {
        return Resource.request(method, url, null, null);
    }

    public static Resource request(RequestMethod method, String url, JSONObject data) throws Exception, RequestDataException, HttpException {
        return Resource.request(method, url, (HttpEntity)Resource.jsonToEntity(data), "json");
    }

    public static Resource request(RequestMethod method, String url, Map<String, String> data) throws Exception, RequestDataException, HttpException {
        return Resource.request(method, url, (HttpEntity)Resource.mapToEntity(data), "urlencoded");
    }

    public static Resource request(RequestMethod method, String url, HttpEntity data, String format) throws Exception, RequestDataException, HttpException {
        int statusCode;
        HttpHead request;
        switch (method) {
            case HTTP_GET: {
                if (data != null && data.getContentLength() > 0L) {
                    url = url.replaceAll("\\{\\?[^}]+\\}$", "");
                    url = url + "?" + Resource.entityToString(data);
                    data = null;
                }
                request = new HttpGet(url);
                break;
            }
            case HTTP_HEAD: {
                request = new HttpHead(url);
                break;
            }
            case HTTP_POST: {
                request = new HttpPost(url);
                break;
            }
            case HTTP_PUT: {
                request = new HttpPut(url);
                break;
            }
            case HTTP_DELETE: {
                request = new HttpDelete(url);
                break;
            }
            case HTTP_TRACE: {
                request = new HttpTrace(url);
                break;
            }
            case HTTP_OPTIONS: {
                request = new HttpOptions(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Method should be one of GET, HEAD, POST, PUT, DELETE, TRACE and OPTIONS.");
            }
        }
        request.addHeader("Accept", "application/hal+json; profile=\"" + Config.getHalProfile() + "\"");
        if (token != null && token.isValid()) {
            request.addHeader("Authorization", "Bearer " + token.getValue());
        } else {
            byte[] basic = Base64.encodeBase64((byte[])(Config.getAppId() + ":" + Config.getAppSecret()).getBytes());
            try {
                request.addHeader("Authorization", "Basic " + new String(basic, CharsetUtils.get((String)"UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                request.addHeader("Authorization", "Basic " + new String(basic));
            }
        }
        if (data != null) {
            ((HttpEntityEnclosingRequestBase)request).setEntity(data);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Attempting to send a request to " + url + " (" + (Object)((Object)method) + ")" + (data != null ? " with the following data:\n" + Resource.entityToString(data) : ""));
        }
        Resource resource = new Resource(client.execute((HttpUriRequest)request));
        CloseableHttpResponse response = resource.getResponse();
        JSONObject body = resource.getBodyAsJson();
        if (LOGGER.isLoggable(Level.INFO)) {
            StatusLine statusLine = response.getStatusLine();
            LOGGER.info("Received a response: " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase() + " " + statusLine.getProtocolVersion());
            if (body != null) {
                LOGGER.info("Response contains the following body:\n" + body.toString(2));
            }
        }
        if ((statusCode = response.getStatusLine().getStatusCode()) == 409 && body != null && body.has("message") && body.has("code")) {
            throw new RequestDataException("Request data is missing or incorrect: " + body.getString("message") + " (error code #" + body.getString("code") + ")");
        }
        if (statusCode != 200 && statusCode != 201) {
            throw new HttpException("HTTP Error " + String.valueOf(statusCode) + ": " + response.getStatusLine().getReasonPhrase());
        }
        return resource;
    }

    public static Resource getRoot() throws Exception, RequestDataException, HttpException {
        Config.validate();
        if (client == null) {
            client = HttpClients.createDefault();
        }
        Resource.oauth();
        return Resource.request(RequestMethod.HTTP_GET, Config.getEntryPoint() + '/');
    }

    protected static void oauth() throws Exception, RequestDataException, HttpException {
        if (token == null) {
            token = new Token();
        } else if (token.isValid()) {
            return;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("grant_type", "client_credentials");
        data.put("scope", "api");
        JSONObject body = Resource.request(RequestMethod.HTTP_POST, Config.getEntryPoint() + "/oauth/token", data).getBodyAsJson();
        if (body == null) {
            throw new Exception("Authentication succeeded but the response is empty");
        }
        String value = body.getString("access_token");
        Long expirationTime = Token.getTime() + body.getLong("expires_in");
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Authentication succeeded. Received token " + value + " valid until timestamp " + expirationTime + ".");
        }
        token.setValue(value);
        token.setExpirationTime(expirationTime);
    }

    public static UrlEncodedFormEntity mapToEntity(Map<String, String> data) throws Exception, RequestDataException, HttpException {
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        for (String key : data.keySet()) {
            urlParameters.add(new BasicNameValuePair(key, data.get(key)));
        }
        return new UrlEncodedFormEntity(urlParameters, CharsetUtils.get((String)"UTF-8"));
    }

    public static StringEntity stringToEntity(String data) throws RequestDataException, HttpException {
        return new StringEntity(data, ContentType.create((String)"application/json", (String)"UTF-8"));
    }

    public static StringEntity jsonToEntity(JSONObject data) throws RequestDataException, HttpException {
        return new StringEntity(data.toString(), ContentType.create((String)"application/json", (String)"UTF-8"));
    }

    public static String entityToString(HttpEntity entity) throws Exception {
        String s;
        InputStreamReader isr = new InputStreamReader(entity.getContent(), ContentType.getOrDefault((HttpEntity)entity).getCharset());
        BufferedReader br = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        while ((s = br.readLine()) != null) {
            sb.append(s);
        }
        isr.close();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            client.close();
        }
        finally {
            super.finalize();
        }
    }
}

