/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSqlQueryCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.OutputTextBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlQueryCommand
extends AbstractSqlQueryCommand {
    @Override
    protected void outputTableData(Dialect dialect, Table table) {
        OutputTextBuilder builder = new OutputTextBuilder();
        builder.append(table);
        this.println(builder.toString());
    }

    @Override
    protected void outputTableData(Dialect dialect, Table table, ResultSet resultSet) throws SQLException {
        StringBuilder builder = new StringBuilder();
        int size = table.getColumns().size();
        for (Column column : table.getColumns()) {
            builder.append(column.getName());
            builder.append(this.getOutputFormatType().getSeparator());
        }
        this.println(builder.substring(0, builder.length() - 1));
        while (resultSet.next()) {
            builder = new StringBuilder();
            for (int i = 1; i <= size; ++i) {
                Object obj = resultSet.getObject(i);
                Column column = (Column)table.getColumns().get(i - 1);
                String text = dialect.getValueForDisplay(column, obj);
                builder.append(text);
                builder.append(this.getOutputFormatType().getSeparator());
            }
            this.println(builder.substring(0, builder.length() - 1));
        }
    }
}

