/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OutputFormatType {
    TSV{

        @Override
        public String getSeparator() {
            return "\t";
        }

        @Override
        public WorkbookFileType getWorkbookFileType() {
            return WorkbookFileType.TSV;
        }
    }
    ,
    CSV{

        @Override
        public String getSeparator() {
            return ",";
        }

        @Override
        public WorkbookFileType getWorkbookFileType() {
            return WorkbookFileType.CSV;
        }
    }
    ,
    FILE{

        @Override
        public boolean isFile() {
            return true;
        }
    }
    ,
    TABLE{

        @Override
        public boolean isTable() {
            return true;
        }
    };


    public String getSeparator() {
        return null;
    }

    public WorkbookFileType getWorkbookFileType() {
        return null;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isTable() {
        return false;
    }

    public static OutputFormatType parse(String text) {
        if (text == null) {
            return null;
        }
        text = text.toUpperCase();
        for (OutputFormatType type : OutputFormatType.values()) {
            if (!text.endsWith(type.toString())) continue;
            return type;
        }
        return null;
    }
}

