/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class QueryDefinitionDataGeneratorSetting {
    @JsonIgnore
    private String colString;
    private String generationGroup;
    private String selectSql;
    @JsonIgnore
    private List<Map<String, Object>> values = CommonUtils.list();

    public void loadData(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement(1003, 1007);
             ResultSet rs = stmt.executeQuery(this.selectSql);){
            Map indexNamelMap = CommonUtils.map();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            int colCount = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String label = resultSetMetaData.getColumnLabel(i);
                indexNamelMap.put(i - 1, label.intern());
            }
            while (rs.next()) {
                Map map = CommonUtils.map();
                for (int i = 0; i < colCount; ++i) {
                    String name = (String)indexNamelMap.get(i);
                    Object value = rs.getObject(i + 1);
                    map.put(name, value);
                }
                this.values.add(map);
            }
        }
    }

    public Map<String, Object> getValueMap(int i) {
        if (this.values.isEmpty()) {
            return Collections.emptyMap();
        }
        int size = this.values.size();
        int pos = i % size;
        return this.values.get(pos);
    }

    @Generated
    public String getColString() {
        return this.colString;
    }

    @Generated
    public String getGenerationGroup() {
        return this.generationGroup;
    }

    @Generated
    public String getSelectSql() {
        return this.selectSql;
    }

    @Generated
    public List<Map<String, Object>> getValues() {
        return this.values;
    }

    @JsonIgnore
    @Generated
    public void setColString(String colString) {
        this.colString = colString;
    }

    @Generated
    public void setGenerationGroup(String generationGroup) {
        this.generationGroup = generationGroup;
    }

    @Generated
    public void setSelectSql(String selectSql) {
        this.selectSql = selectSql;
    }

    @JsonIgnore
    @Generated
    public void setValues(List<Map<String, Object>> values) {
        this.values = values;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryDefinitionDataGeneratorSetting)) {
            return false;
        }
        QueryDefinitionDataGeneratorSetting other = (QueryDefinitionDataGeneratorSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$colString = this.getColString();
        String other$colString = other.getColString();
        if (this$colString == null ? other$colString != null : !this$colString.equals(other$colString)) {
            return false;
        }
        String this$generationGroup = this.getGenerationGroup();
        String other$generationGroup = other.getGenerationGroup();
        if (this$generationGroup == null ? other$generationGroup != null : !this$generationGroup.equals(other$generationGroup)) {
            return false;
        }
        String this$selectSql = this.getSelectSql();
        String other$selectSql = other.getSelectSql();
        if (this$selectSql == null ? other$selectSql != null : !this$selectSql.equals(other$selectSql)) {
            return false;
        }
        List<Map<String, Object>> this$values = this.getValues();
        List<Map<String, Object>> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueryDefinitionDataGeneratorSetting;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $colString = this.getColString();
        result = result * 59 + ($colString == null ? 43 : $colString.hashCode());
        String $generationGroup = this.getGenerationGroup();
        result = result * 59 + ($generationGroup == null ? 43 : $generationGroup.hashCode());
        String $selectSql = this.getSelectSql();
        result = result * 59 + ($selectSql == null ? 43 : $selectSql.hashCode());
        List<Map<String, Object>> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }
}

