/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractTableCommand;
import com.sqlapp.data.db.command.OutputFormatType;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.OutputTextBuilder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class CountAllTablesCommand
extends AbstractTableCommand {
    private OutputFormatType outputFormatType = OutputFormatType.TSV;

    @Override
    protected void doRun() {
        Table result = new Table();
        result.getColumns().add((AbstractNamedObject)((Column)new Column("schemaName").setDataType(DataType.NVARCHAR).setLength(254L)));
        result.getColumns().add((AbstractNamedObject)((Column)new Column("tableName").setDataType(DataType.NVARCHAR).setLength(254L)));
        result.getColumns().add((AbstractNamedObject)new Column("count").setDataType(DataType.BIGINT));
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            Dialect dialect = this.getDialect((Connection)connection);
            try (Statement statement = connection.createStatement();){
                Object builder;
                SchemaReader schemaReader = this.getSchemaReader((Connection)connection, dialect);
                Map<String, Schema> schemaMap = this.getSchemas((Connection)connection, dialect, schemaReader, s -> true);
                if (!this.getOutputFormatType().isTable()) {
                    builder = new StringBuilder();
                    for (Column column : result.getColumns()) {
                        ((StringBuilder)builder).append(column.getName());
                        ((StringBuilder)builder).append(this.getOutputFormatType().getSeparator());
                    }
                    this.info((Object)((StringBuilder)builder).substring(0, ((StringBuilder)builder).length() - 1));
                }
                for (Map.Entry entry : schemaMap.entrySet()) {
                    for (Table table : ((Schema)entry.getValue()).getTables()) {
                        Row row = result.newRow();
                        row.put("schemaName", entry.getKey());
                        row.put("tableName", (Object)table.getName());
                        AbstractSqlBuilder sqlBuilder = dialect.createSqlBuilder();
                        sqlBuilder.select().count("*").from().name((AbstractSchemaObject)table);
                        StringBuilder builder2 = new StringBuilder();
                        builder2.append((String)entry.getKey());
                        builder2.append(this.getOutputFormatType().getSeparator());
                        builder2.append(table.getName());
                        long count = this.selectCount(dialect, statement, table);
                        row.put("count", (Object)count);
                        builder2.append(this.getOutputFormatType().getSeparator());
                        builder2.append(count);
                        if (!this.getOutputFormatType().isTable()) {
                            this.info((Object)builder2);
                        }
                        result.getRows().add(row);
                    }
                }
                if (this.getOutputFormatType().isTable()) {
                    builder = new OutputTextBuilder();
                    builder.append(result);
                    this.info((Object)builder.toString());
                }
            }
        }));
    }

    private long selectCount(Dialect dialect, Statement statement, Table table) throws SQLException {
        AbstractSqlBuilder sqlBuilder = dialect.createSqlBuilder();
        sqlBuilder.select().count("*").from().name((AbstractSchemaObject)table);
        try (ResultSet resultSet = statement.executeQuery(sqlBuilder.toString());){
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    public OutputFormatType getOutputFormatType() {
        return this.outputFormatType;
    }

    public void setOutputFormatType(OutputFormatType outputFormatType) {
        this.outputFormatType = outputFormatType;
    }
}

