/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSchemaDataSourceCommand;
import com.sqlapp.data.db.command.ConvertHandler;
import com.sqlapp.data.db.command.properties.FilesProperty;
import com.sqlapp.data.db.command.properties.SchemaOptionProperty;
import com.sqlapp.data.db.command.properties.SqlExecutorProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.DefaultSqlExecutor;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlExecutor;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.sql.Connection;
import java.util.List;
import lombok.Generated;

public abstract class AbstractFile2DataSourceCommand<T>
extends AbstractSchemaDataSourceCommand
implements SchemaOptionProperty,
SqlExecutorProperty,
FilesProperty {
    private File[] files = null;
    private SqlExecutor sqlExecutor = DefaultSqlExecutor.getInstance();
    private Options schemaOptions = new Options();

    @Override
    protected void doRun() {
        List totalObjects = CommonUtils.list();
        ConvertHandler convertHandler = this.getConvertHandler();
        for (File file : this.getFiles()) {
            this.execute(() -> {
                DbCommonObject dbCommonObject = SchemaUtils.readXml((File)file);
                totalObjects.add(dbCommonObject);
            });
        }
        List convertedTotalObjects = convertHandler.handle(totalObjects);
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            Dialect dialect = this.getDialect((Connection)connection);
            this.handle(convertedTotalObjects, (Connection)connection, dialect);
        }));
    }

    protected void handle(List<DbCommonObject<?>> totalObjects, Connection connection, Dialect dialect) throws Exception {
        SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry(dialect);
        sqlFactoryRegistry.setOption(this.getSchemaOptions());
        List<T> list = this.getTarget(totalObjects, connection, dialect);
        list = this.filter(list);
        list = this.sort(list);
        this.handle((T)list, sqlFactoryRegistry, connection, dialect);
    }

    protected abstract List<T> getTarget(List<DbCommonObject<?>> var1, Connection var2, Dialect var3);

    protected List<T> filter(List<T> list) {
        return list;
    }

    protected List<T> sort(List<T> list) {
        return list;
    }

    protected void handle(List<T> list, SqlFactoryRegistry sqlFactoryRegistry, Connection connection, Dialect dialect) throws Exception {
        for (T obj : list) {
            this.handle(obj, sqlFactoryRegistry, connection, dialect);
        }
    }

    protected abstract void handle(T var1, SqlFactoryRegistry var2, Connection var3, Dialect var4) throws Exception;

    @Override
    public void setFiles(File ... obj) {
        this.files = obj;
    }

    @Override
    @Generated
    public File[] getFiles() {
        return this.files;
    }

    @Override
    @Generated
    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    @Override
    @Generated
    public Options getSchemaOptions() {
        return this.schemaOptions;
    }

    @Override
    @Generated
    public void setSqlExecutor(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    @Override
    @Generated
    public void setSchemaOptions(Options schemaOptions) {
        this.schemaOptions = schemaOptions;
    }
}

