/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.util.CommonUtils;
import java.io.File;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GeneratorSettingFileType {
    EXCEL2007{

        @Override
        public WorkbookFileType getWorkbookFileType() {
            return WorkbookFileType.EXCEL2007;
        }
    }
    ,
    JSON{

        @Override
        public WorkbookFileType getWorkbookFileType() {
            return WorkbookFileType.JSON;
        }
    }
    ,
    YAML{

        @Override
        public WorkbookFileType getWorkbookFileType() {
            return WorkbookFileType.YAML;
        }
    };


    public WorkbookFileType getWorkbookFileType() {
        return null;
    }

    public static GeneratorSettingFileType parse(File file) {
        if (CommonUtils.isEmpty((Object)file)) {
            return null;
        }
        for (GeneratorSettingFileType enm : GeneratorSettingFileType.values()) {
            if (!enm.getWorkbookFileType().match(file.getName())) continue;
            return enm;
        }
        return null;
    }

    public static GeneratorSettingFileType parse(String value) {
        if (CommonUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        String upper = value.toUpperCase();
        for (GeneratorSettingFileType enm : GeneratorSettingFileType.values()) {
            if (!enm.toString().equals(upper)) continue;
            return enm;
        }
        return null;
    }
}

