/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.generator.setting.ColumnGeneratorSetting;
import com.sqlapp.data.db.command.generator.setting.QueryGeneratorSetting;
import com.sqlapp.data.db.command.generator.setting.TableGeneratorSetting;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.rowiterator.ExcelUtils;
import com.sqlapp.util.CommonUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GeneratorSettingWorkbook {
    Table{

        @Override
        public void writeSheet(TableGeneratorSetting setting, Workbook wb) {
            String sheetName = this.name();
            Sheet sheet = ExcelUtils.getOrCreateSheet((Workbook)wb, (String)sheetName);
            sheet.setDisplayGridlines(false);
            int i = 0;
            int j = 0;
            Row row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j, "Table Name", null);
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j, "[1] Setup SQL\n(1 execution)", null);
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j, "[2] Start Value SQL\n(1 execution)", null);
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j, "[3] Number of Rows", null);
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j, "[4] Insert SQL\n([2]\u00d7[3] execution)", null);
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j, "[5] Finalize SQL\n(1 execution)", null);
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            i = 0;
            j = 1;
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValue(row, j, setting.getName());
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValue(row, j, setting.getSetupSql());
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValue(row, j, setting.getStartValueSql());
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValue(row, j, setting.getNumberOfRows());
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValue(row, j, setting.getInsertSql());
            row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValue(row, j, setting.getFinalizeSql());
        }

        @Override
        public void readFromSheet(Workbook wb, TableGeneratorSetting setting) {
            String sheetName = this.name();
            Sheet sheet = ExcelUtils.getSheet((Workbook)wb, (String)sheetName);
            int i = 0;
            int j = 1;
            Row row = sheet.getRow(i++);
            Cell cell = ExcelUtils.getOrCreateCell((Row)row, (int)j);
            setting.setName((String)ExcelUtils.getCellValue((Cell)cell, String.class));
            row = sheet.getRow(i++);
            cell = ExcelUtils.getOrCreateCell((Row)row, (int)j);
            setting.setSetupSql((String)ExcelUtils.getCellValue((Cell)cell, String.class));
            row = sheet.getRow(i++);
            cell = ExcelUtils.getOrCreateCell((Row)row, (int)j);
            setting.setStartValueSql((String)ExcelUtils.getCellValue((Cell)cell, String.class));
            row = sheet.getRow(i++);
            cell = ExcelUtils.getOrCreateCell((Row)row, (int)j);
            setting.setNumberOfRows((Long)ExcelUtils.getCellValue((Cell)cell, Long.class));
            row = sheet.getRow(i++);
            cell = ExcelUtils.getOrCreateCell((Row)row, (int)j);
            setting.setInsertSql((String)ExcelUtils.getCellValue((Cell)cell, String.class));
            row = sheet.getRow(i++);
            cell = ExcelUtils.getOrCreateCell((Row)row, (int)j);
            setting.setFinalizeSql((String)ExcelUtils.getCellValue((Cell)cell, String.class));
        }
    }
    ,
    Column{

        @Override
        public void writeSheet(TableGeneratorSetting setting, Workbook wb) {
            String sheetName = this.name();
            Sheet sheet = ExcelUtils.getOrCreateSheet((Workbook)wb, (String)sheetName);
            sheet.setDisplayGridlines(false);
            int i = 0;
            int j = 0;
            int valuesMax = 30;
            Row row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j++, COLUMN_NAME, null);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j++, DATA_TYPE, null);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j++, GENERATION_GROUP, null);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j++, MIN_VALUE, null);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j++, MAX_VALUE, AVAILABLE_VAR + "\n====\n" + MIN_VALUE + " : _min.[" + COLUMN_NAME + "]");
            GeneratorSettingWorkbook.setCellValueForHeader(row, j++, NEXT_VALUE, AVAILABLE_VAR + "\n====\n_index\n" + MIN_VALUE + " : _min.[" + COLUMN_NAME + "]\n" + MAX_VALUE + " : _max.[" + COLUMN_NAME + "]\n" + PREVIOUS_VALUE + " : _previous.[" + COLUMN_NAME + "]");
            GeneratorSettingWorkbook.setCellValueForHeader(row, j++, VALUES, null);
            for (int k = 0; k < 30; ++k) {
                GeneratorSettingWorkbook.setCellValueForHeader(row, j++, null, null);
            }
            for (Map.Entry<String, ColumnGeneratorSetting> entry : setting.getColumns().entrySet()) {
                j = 0;
                row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
                ColumnGeneratorSetting col = entry.getValue();
                GeneratorSettingWorkbook.setCellValue(row, j++, col.getName());
                GeneratorSettingWorkbook.setCellValue(row, j++, col.getDataType());
                GeneratorSettingWorkbook.setCellValue(row, j++, col.getGenerationGroup());
                GeneratorSettingWorkbook.setCellValue(row, j++, col.getMinValue());
                GeneratorSettingWorkbook.setCellValue(row, j++, col.getMaxValue());
                GeneratorSettingWorkbook.setCellValue(row, j++, col.getNextValue());
                GeneratorSettingWorkbook.setCellValue(row, j++, col.getValues());
                if (!CommonUtils.isEmpty(col.getValues())) {
                    j += col.getValues().size();
                }
                for (int k = 0; k < 30; ++k) {
                    GeneratorSettingWorkbook.setCellValue(row, j++, null);
                }
            }
        }

        @Override
        public void readFromSheet(Workbook wb, TableGeneratorSetting setting) {
            String sheetName = this.name();
            Sheet sheet = ExcelUtils.getSheet((Workbook)wb, (String)sheetName);
            int max = sheet.getLastRowNum();
            for (int i = 1; i <= max; ++i) {
                Object val;
                String name;
                Row row = sheet.getRow(i);
                int j = 0;
                ColumnGeneratorSetting def = new ColumnGeneratorSetting();
                if (CommonUtils.isBlank((CharSequence)(name = (String)ExcelUtils.getCellValue((Row)row, (int)j++, String.class)))) {
                    return;
                }
                def.setName(name);
                def.setDataType((DataType)ExcelUtils.getCellValue((Row)row, (int)j++, DataType.class));
                def.setGenerationGroup((String)ExcelUtils.getCellValue((Row)row, (int)j++, String.class));
                def.setMinValue((String)ExcelUtils.getCellValue((Row)row, (int)j++, String.class));
                def.setMaxValue((String)ExcelUtils.getCellValue((Row)row, (int)j++, String.class));
                def.setNextValue((String)ExcelUtils.getCellValue((Row)row, (int)j++, String.class));
                while (j < row.getLastCellNum() && !CommonUtils.isEmpty((Object)(val = ExcelUtils.getCellValue((Row)row, (int)j++)))) {
                    Object obj = Converters.getDefault().convertObject(val, def.getDataType().getDefaultClass());
                    if (def.getValues() == null) {
                        def.setValues(CommonUtils.list());
                    }
                    def.getValues().add(obj);
                }
                setting.addColumn(def);
            }
        }
    }
    ,
    Query{

        @Override
        public void writeSheet(TableGeneratorSetting setting, Workbook wb) {
            String sheetName = this.name();
            Sheet sheet = ExcelUtils.getOrCreateSheet((Workbook)wb, (String)sheetName);
            sheet.setDisplayGridlines(false);
            int i = 0;
            int j = 0;
            Row row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j++, GENERATION_GROUP, GeneratorSettingWorkbook.GENERATION_GROUP_NAME_COMMENT);
            GeneratorSettingWorkbook.setCellValueForHeader(row, j++, SELECT_SQL, GeneratorSettingWorkbook.SELECT_SQL_COMMENT);
            for (Map.Entry<String, QueryGeneratorSetting> entry : setting.getQuerys().entrySet()) {
                j = 0;
                row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)i++);
                QueryGeneratorSetting col = entry.getValue();
                GeneratorSettingWorkbook.setCellValue(row, j++, col.getGenerationGroup());
                GeneratorSettingWorkbook.setCellValue(row, j++, col.getSelectSql(), true);
            }
        }

        @Override
        public void readFromSheet(Workbook wb, TableGeneratorSetting setting) {
            String sheetName = this.name();
            Sheet sheet = ExcelUtils.getSheet((Workbook)wb, (String)sheetName);
            for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
                Row row = sheet.getRow(i);
                int j = 0;
                QueryGeneratorSetting def = new QueryGeneratorSetting();
                def.setGenerationGroup((String)ExcelUtils.getCellValue((Row)row, (int)j++, String.class));
                if (CommonUtils.isBlank((CharSequence)def.getGenerationGroup())) {
                    return;
                }
                def.setSelectSql((String)ExcelUtils.getCellValue((Row)row, (int)j++, String.class));
                setting.addQueryDefinition(def);
            }
        }
    };

    private static final String GENERATION_GROUP_NAME_COMMENT = "If the name given here is set to the group name of the column sheet, the results of the SELECT SQL will be used.";
    private static final String SELECT_SQL_COMMENT = "Execute SQL with column names in AS and set to the group name of the column sheet, the results of the SELECT SQL will be used sequentially.";
    private static String COLUMN_NAME;
    private static String DATA_TYPE;
    private static String GENERATION_GROUP;
    private static String MIN_VALUE;
    private static String PREVIOUS_VALUE;
    private static String MAX_VALUE;
    private static String NEXT_VALUE;
    private static String VALUES;
    private static String AVAILABLE_VAR;
    private static String SELECT_SQL;

    public void writeSheet(TableGeneratorSetting setting, Workbook wb) {
    }

    public void readFromSheet(Workbook wb, TableGeneratorSetting setting) {
    }

    public static TableGeneratorSetting readWorkbook(Workbook wb) {
        TableGeneratorSetting setting = new TableGeneratorSetting();
        for (GeneratorSettingWorkbook enm : GeneratorSettingWorkbook.values()) {
            enm.readFromSheet(wb, setting);
        }
        setting.check();
        return setting;
    }

    private static void setCellValueForHeader(Row row, int colIndex, Object value, String cellComment) {
        GeneratorSettingWorkbook.setCellValueForHeader(row, colIndex, value, cellComment, false, (sheet, cellStyle) -> {
            cellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setFont(GeneratorSettingWorkbook.getFont(sheet.getWorkbook()));
        });
    }

    private static void setCellValueForHeader(Row row, int colIndex, Object value, String cellComment, boolean rowAutoHeight, BiConsumer<Sheet, CellStyle> cellStyleConsumer) {
        ExcelUtils.setCell((Row)row, (int)colIndex, cell -> {
            Sheet sheet = cell.getSheet();
            CellStyle cellStyle = ExcelUtils.createCellStyle((Workbook)sheet.getWorkbook(), (BorderStyle)BorderStyle.THIN);
            if (cellStyleConsumer != null) {
                cellStyleConsumer.accept(sheet, cellStyle);
            }
            cellStyle.setFont(GeneratorSettingWorkbook.getFont(sheet.getWorkbook()));
            sheet.autoSizeColumn(cell.getColumnIndex());
            cell.setCellStyle(cellStyle);
            ExcelUtils.setCell((Cell)cell, (Object)value);
            sheet.autoSizeColumn(cell.getColumnIndex());
            if (rowAutoHeight) {
                GeneratorSettingWorkbook.setRowAutoHeight(row, value);
            }
            if (cellComment != null) {
                ExcelUtils.setComment((Cell)cell, (String)cellComment);
            }
        });
    }

    private static void setCellValue(Row row, int colIndex, Object value) {
        GeneratorSettingWorkbook.setCellValue(row, colIndex, value, false);
    }

    private static void setCellValue(Row row, int colIndex, Object value, boolean rowAutoHeight) {
        GeneratorSettingWorkbook.setCellValue(row, colIndex, value, rowAutoHeight, (sheet, cellStyle) -> {
            cellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setFont(GeneratorSettingWorkbook.getFont(sheet.getWorkbook()));
        });
    }

    private static void setCellValue(Row row, int colIndex, Object value, boolean rowAutoHeight, BiConsumer<Sheet, CellStyle> cellStyleConsumer) {
        ExcelUtils.setCell((Row)row, (int)colIndex, cell -> {
            Sheet sheet = cell.getSheet();
            CellStyle cellStyle = ExcelUtils.createCellStyle((Workbook)sheet.getWorkbook(), (BorderStyle)BorderStyle.THIN);
            if (cellStyleConsumer != null) {
                cellStyleConsumer.accept(sheet, cellStyle);
            }
            cellStyle.setFont(GeneratorSettingWorkbook.getFont(sheet.getWorkbook()));
            if (!(value instanceof List)) {
                sheet.autoSizeColumn(cell.getColumnIndex());
                if (rowAutoHeight) {
                    GeneratorSettingWorkbook.setRowAutoHeight(row, value);
                }
                cellStyle.setWrapText(true);
                cell.setCellStyle(cellStyle);
                ExcelUtils.setCell((Cell)cell, (Object)value);
                sheet.autoSizeColumn(cell.getColumnIndex());
            } else {
                List values = (List)value;
                if (CommonUtils.isEmpty((Collection)values)) {
                    return;
                }
                ExcelUtils.setCell((Cell)cell, values.get(0));
                sheet.autoSizeColumn(cell.getColumnIndex());
                for (int i = 1; i < values.size(); ++i) {
                    cell = ExcelUtils.getOrCreateCell((Row)row, (int)i);
                    cell.setCellStyle(cellStyle);
                    cellStyle.setWrapText(true);
                    ExcelUtils.setCell((Cell)cell, values.get(i));
                    sheet.autoSizeColumn(cell.getColumnIndex());
                }
            }
        });
    }

    private static void setRowAutoHeight(Row row, Object value) {
        if (!(value instanceof String)) {
            return;
        }
        String[] args = ((String)String.class.cast(value)).split("\n");
        row.setHeightInPoints((float)(15 * args.length));
    }

    private static Font getFont(Workbook wb) {
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)11);
        font.setTypeOffset((short)0);
        return font;
    }

    static {
        COLUMN_NAME = "Column Name";
        DATA_TYPE = "Data Type";
        GENERATION_GROUP = "Generation Group";
        MIN_VALUE = "Min Value";
        PREVIOUS_VALUE = "Previous Value";
        MAX_VALUE = "Max Value";
        NEXT_VALUE = "Next Value";
        VALUES = "Values";
        AVAILABLE_VAR = "Available Variables";
        SELECT_SQL = "Select SQL";
    }
}

