/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator.factory;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.AbstractSqlBuilder;
import java.io.Serializable;
import java.util.function.BiFunction;

public class ColumnStartValue
implements BiFunction<Column, Dialect, String>,
Serializable {
    private static final long serialVersionUID = -2049712084354162318L;

    @Override
    public String apply(Column column, Dialect dialect) {
        if (column.getParent() != null && column.getParent().getParent() != null) {
            Table table = column.getParent().getParent();
            if (table.getPrimaryKeyConstraint() == null) {
                return this.getExpression(column, dialect);
            }
            boolean contains = table.getPrimaryKeyConstraint().getColumns().contains(column.getName());
            if (contains) {
                return this.getExpression(column, dialect);
            }
            return null;
        }
        return this.getExpression(column, dialect);
    }

    protected String getExpression(Column column, Dialect dialect) {
        if (column.getDataType().isNumeric()) {
            if (column.getDataType() == DataType.FLOAT || column.getDataType() == DataType.DOUBLE) {
                return this.getNullExpression(column, dialect);
            }
            return this.getNumberExpression(column, dialect);
        }
        return this.getMaxExpression(column, dialect);
    }

    protected String getNumberExpression(Column column, Dialect dialect) {
        AbstractSqlBuilder builder = dialect.createSqlBuilder();
        builder.coalesce().brackets(() -> {
            builder.max().brackets(() -> builder.name(column));
            builder.comma()._add("0");
        }).as().name(column);
        return builder.toString();
    }

    protected String getMaxExpression(Column column, Dialect dialect) {
        AbstractSqlBuilder builder = dialect.createSqlBuilder();
        builder.max().brackets(() -> builder.name(column)).as().name(column);
        return builder.toString();
    }

    protected String getNullExpression(Column column, Dialect dialect) {
        AbstractSqlBuilder builder = dialect.createSqlBuilder();
        builder.max().brackets(() -> builder._null()).as().name(column);
        return builder.toString();
    }
}

