/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSqlCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class SqlExecuteCommand
extends AbstractSqlCommand {
    private List<File> sqlFiles = null;
    private List<String> sqlText = null;

    @Override
    protected void doRun() {
        Connection connection = null;
        try {
            ParametersContext context;
            connection = this.getConnection();
            connection.setAutoCommit(false);
            Dialect dialect = this.getDialect(connection);
            SqlSplitter sqlSplitter = dialect.createSqlSplitter();
            SqlConverter sqlConverter = this.getSqlConverter();
            for (File file : this.getSqlFiles()) {
                context = new ParametersContext();
                context.putAll(this.getContext());
                String text = FileUtils.readText((File)file, (String)this.getEncoding());
                List sqls = sqlSplitter.parse(text);
                for (SqlSplitter.SplitResult splitResult : sqls) {
                    SqlNode sqlNode = sqlConverter.parseSql(context, splitResult.getText());
                    JdbcHandler jdbcHandler = dialect.createJdbcHandler(sqlNode);
                    jdbcHandler.execute(connection, context);
                }
            }
            for (String text : this.getSqlText()) {
                context = new ParametersContext();
                context.putAll(this.getContext());
                List sqls = sqlSplitter.parse(text);
                for (SqlSplitter.SplitResult splitResult : sqls) {
                    SqlNode sqlNode = sqlConverter.parseSql(context, splitResult.getText());
                    JdbcHandler jdbcHandler = dialect.createJdbcHandler(sqlNode);
                    jdbcHandler.execute(connection, context);
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    protected List<File> getSqlFiles() {
        return this.sqlFiles;
    }

    public void setSqlFiles(List<File> sqlFiles) {
        this.sqlFiles = sqlFiles;
    }

    public void setSqlFiles(File ... sqlFiles) {
        this.sqlFiles = CommonUtils.isEmpty((Object)sqlFiles) ? Collections.emptyList() : CommonUtils.list((Object[])sqlFiles);
    }

    public void setSqlFiles(String ... sqlPaths) {
        if (CommonUtils.isEmpty((Object)sqlPaths)) {
            this.sqlFiles = Collections.emptyList();
        } else {
            this.sqlFiles = CommonUtils.list();
            for (String sqlPath : sqlPaths) {
                this.sqlFiles.add(new File(sqlPath));
            }
        }
    }

    protected List<String> getSqlText() {
        return this.sqlText;
    }

    public void setSqlText(List<String> sqlText) {
        this.sqlText = sqlText;
    }

    public void setSqlText(String ... args) {
        if (CommonUtils.isEmpty((Object)args)) {
            this.sqlText = Collections.emptyList();
        } else {
            this.sqlText = CommonUtils.list();
            for (String arg : args) {
                if (CommonUtils.isEmpty((CharSequence)arg)) continue;
                this.sqlText.add(arg);
            }
        }
    }
}

