/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSchemaDataSourceCommand;
import com.sqlapp.data.db.command.ConvertHandler;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlExecutor;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.StandardOutSqlExecutor;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractFile2DataSourceCommand<T>
extends AbstractSchemaDataSourceCommand {
    private File[] files = null;
    private SqlExecutor sqlExecutor = new StandardOutSqlExecutor();
    private Options sqlOptions = new Options();

    @Override
    protected void doRun() {
        List<DbCommonObject<?>> totalObjects = CommonUtils.list();
        ConvertHandler convertHandler = this.getConvertHandler();
        for (File file : this.getFiles()) {
            try {
                DbCommonObject dbCommonObject = SchemaUtils.readXml((File)file);
                totalObjects.add(dbCommonObject);
            }
            catch (IOException e) {
                this.getExceptionHandler().handle((Throwable)e);
            }
            catch (XMLStreamException e) {
                this.getExceptionHandler().handle((Throwable)e);
            }
        }
        totalObjects = convertHandler.handle((List<? extends DbCommonObject>)totalObjects);
        Connection connection = this.getConnection();
        try {
            this.handle(totalObjects, connection);
        }
        catch (Exception e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    protected void handle(List<DbCommonObject<?>> totalObjects, Connection connection) throws Exception {
        SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry();
        sqlFactoryRegistry.setOption(this.getSqlOptions());
        List<T> list = this.getTarget(totalObjects, connection);
        list = this.filter(list);
        list = this.sort(list);
        this.handle((T)list, sqlFactoryRegistry, connection);
    }

    protected abstract List<T> getTarget(List<DbCommonObject<?>> var1, Connection var2);

    protected List<T> filter(List<T> list) {
        return list;
    }

    protected List<T> sort(List<T> list) {
        return list;
    }

    protected void handle(List<T> list, SqlFactoryRegistry sqlFactoryRegistry, Connection connection) throws Exception {
        for (T obj : list) {
            this.handle(obj, sqlFactoryRegistry, connection);
        }
    }

    protected abstract void handle(T var1, SqlFactoryRegistry var2, Connection var3) throws Exception;

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public void setSqlExecutor(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFiles(File ... files) {
        this.files = files;
    }

    public Options getSqlOptions() {
        return this.sqlOptions;
    }

    public void setSqlOption(Options sqlOptions) {
        this.sqlOptions = sqlOptions;
    }
}

