/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.metadata.SequenceReader;
import com.sqlapp.data.db.metadata.SynonymReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.parameter.ParametersContextBuilder;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.Synonym;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.sql.SqlComparisonOperator;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public abstract class AbstractSchemaDataSourceCommand
extends AbstractDataSourceCommand {
    private SqlFactoryRegistry sqlFactoryRegistry;

    public SqlFactoryRegistry getSqlFactoryRegistry(Dialect dialect) {
        if (this.sqlFactoryRegistry != null) {
            return this.sqlFactoryRegistry;
        }
        if (dialect != null) {
            this.sqlFactoryRegistry = dialect.createSqlFactoryRegistry();
        }
        return this.sqlFactoryRegistry;
    }

    public void setSqlFactoryRegistry(SqlFactoryRegistry sqlFactoryRegistry) {
        this.sqlFactoryRegistry = sqlFactoryRegistry;
    }

    protected Map<String, Schema> getSchemas(Connection connection, Dialect dialect, SchemaReader schemaReader, Predicate<Schema> schemaNameFilter) {
        SynonymReader synonymReader;
        Catalog catalog = new Catalog();
        Map schemaMap = CommonUtils.linkedMap();
        List schemas = schemaReader.getAll(connection);
        Map allSchemaMap = CommonUtils.linkedMap();
        Set catalogNames = CommonUtils.treeSet();
        Set schemaNames = CommonUtils.treeSet();
        if (!schemas.isEmpty()) {
            Schema schema = (Schema)schemas.get(0);
            this.copyDBInfo(schema, catalog);
        }
        schemas.forEach(s -> {
            catalog.getSchemas().add((AbstractNamedObject)s);
            allSchemaMap.put(s.getName(), s);
            if (schemaNameFilter.test((Schema)s)) {
                schemaMap.put(s.getName(), s);
                if (s.getCatalogName() != null) {
                    catalogNames.add(s.getCatalogName());
                }
                if (s.getName() != null) {
                    schemaNames.add(s.getName());
                }
            }
        });
        DoubleKeyMap tableMap = CommonUtils.doubleKeyMap();
        ParametersContext context = ParametersContextBuilder.create().catalogName(SqlComparisonOperator.IN, (Object)catalogNames).schemaName(SqlComparisonOperator.IN, (Object)schemaNames).build();
        TableReader tableReader = schemaReader.getTableReader();
        List tables = tableReader.getAllFull(connection, context);
        tables.forEach(s -> {
            Schema schema = (Schema)allSchemaMap.get(s.getSchemaName());
            if (schema != null) {
                schema.getTables().add((AbstractNamedObject)s);
            }
        });
        SequenceReader sequenceReader = schemaReader.getSequenceReader();
        if (sequenceReader != null) {
            List sequences = sequenceReader.getAllFull(connection, context);
            sequences.forEach(s -> {
                Schema schema = (Schema)allSchemaMap.get(s.getSchemaName());
                if (schema != null) {
                    schema.getSequences().add((AbstractNamedObject)s);
                }
            });
        }
        if ((synonymReader = schemaReader.getSynonymReader()) != null) {
            synonymReader.setCatalogName(null);
            synonymReader.setSchemaName(null);
            List synonyms = synonymReader.getAllFull(connection);
            if (!synonyms.isEmpty()) {
                DoubleKeyMap rootSynonymMap = CommonUtils.doubleKeyMap();
                synonyms.forEach(s -> {
                    Schema schema = (Schema)allSchemaMap.get(s.getSchemaName());
                    if (schema != null) {
                        schema.getSynonyms().add((AbstractNamedObject)s);
                    }
                });
                synonyms.forEach(s -> {
                    Synonym root = s.rootSynonym();
                    rootSynonymMap.put((Object)root.getSchemaName(), (Object)root.getName(), (Object)root);
                });
                this.readSynonymTables(connection, tableReader, allSchemaMap, (DoubleKeyMap<String, String, Synonym>)rootSynonymMap, (DoubleKeyMap<String, String, Table>)tableMap);
            }
        }
        return schemaMap;
    }

    private void copyDBInfo(Schema schema, Catalog catalog) {
        catalog.setProductName(schema.getProductName());
        catalog.setProductMajorVersion(schema.getProductMajorVersion());
        catalog.setProductMinorVersion(schema.getProductMinorVersion());
        catalog.setProductRevision(schema.getProductRevision());
        catalog.setDialect(schema.getDialect());
    }

    private void readSynonymTables(Connection connection, TableReader tableReader, Map<String, Schema> allSchemaMap, DoubleKeyMap<String, String, Synonym> rootSynonymMap, DoubleKeyMap<String, String, Table> tableMap) {
        Set schemaNames = CommonUtils.treeSet();
        Set tableNames = CommonUtils.treeSet();
        rootSynonymMap.toList().forEach(s -> {
            if (!tableMap.containsKey((Object)s.getObjectSchemaName(), (Object)s.getObjectName())) {
                if (s.getObjectSchemaName() != null) {
                    schemaNames.add(s.getObjectSchemaName());
                }
                if (s.getObjectName() != null) {
                    tableNames.add(s.getObjectName());
                }
            }
        });
        if (CommonUtils.isEmpty((Collection)schemaNames)) {
            return;
        }
        ParametersContext context = ParametersContextBuilder.create().schemaName(SqlComparisonOperator.IN, (Object)schemaNames).tableName(SqlComparisonOperator.IN, (Object)tableNames).build();
        List tables = tableReader.getAllFull(connection, context);
        tables.forEach(t -> {
            Schema schema = (Schema)allSchemaMap.get(t.getSchemaName());
            if (!schema.getTables().contains(t.getName())) {
                schema.getTables().add((AbstractNamedObject)t);
            }
        });
    }
}

