/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSynchronizeCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.MetadataReaderUtils;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ExcludeFilterEqualsHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.CatalogNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;
import java.sql.Connection;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class SynchronizeDataCommand
extends AbstractSynchronizeCommand {
    private final SqlType sqlType = SqlType.MERGE_BY_PK;

    public SynchronizeDataCommand() {
        this.setEqualsHandler((EqualsHandler)new ExcludeFilterEqualsHandler(new String[]{SchemaProperties.CREATED_AT.getLabel(), SchemaProperties.LAST_ALTERED_AT.getLabel()}));
    }

    @Override
    protected void handle(List<DbCommonObject<?>> totalObjects, Connection connection, Dialect dialect) throws Exception {
        for (DbCommonObject<?> object : totalObjects) {
            MetadataReader reader = MetadataReaderUtils.getMetadataReader((Dialect)dialect, (String)SchemaUtils.getSingularName((String)object.getClass().getSimpleName()));
            String catalogName = null;
            if (object instanceof CatalogNameProperty) {
                catalogName = ((CatalogNameProperty)object).getCatalogName();
            }
            SimpleBeanUtils.setValueCI((Object)reader, (String)SchemaProperties.CATALOG_NAME.getLabel(), (Object)catalogName);
            if (object instanceof Schema) {
                this.handle((Schema)object, connection, dialect);
            }
            if (object instanceof Catalog) {
                this.handle((Catalog)object, connection, dialect);
            }
            if (!Table.class.equals(object.getClass())) continue;
            this.handle((Table)object, connection, dialect);
        }
    }

    protected void handle(Catalog obj, Connection connection, Dialect dialect) throws Exception {
        List tables = CommonUtils.list();
        for (Schema schema : obj.getSchemas()) {
            tables.addAll(schema.getTables());
        }
        tables = SchemaUtils.getNewSortedTableList((List)tables, (Comparator)Table.TableOrder.CREATE.getComparator());
        for (Table table : tables) {
            this.handle(table, connection, dialect);
        }
    }

    protected void handle(Schema obj, Connection connection, Dialect dialect) throws Exception {
        List tables = SchemaUtils.getNewSortedTableList((List)obj.getTables(), (Comparator)Table.TableOrder.CREATE.getComparator());
        for (Table table : tables) {
            this.handle(table, connection, dialect);
        }
    }

    protected void handle(Table obj, Connection connection, Dialect dialect) throws Exception {
        SqlFactory sqlFactory = this.getSqlFactoryRegistry(dialect).getSqlFactory((DbCommonObject)obj, this.sqlType);
        List sqls = sqlFactory.createSql((DbCommonObject)obj);
        this.getSqlExecutor().execute((Collection)sqls);
    }
}

