/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import com.stackify.api.StackifyError;
import com.stackify.api.common.http.HttpUrlConnections;
import com.stackify.api.json.StackifyErrorConverter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class StackifyErrorSender {
    private final StackifyErrorConverter errorConverter;

    public StackifyErrorSender(StackifyErrorConverter errorWriter) {
        if (errorWriter == null) {
            throw new NullPointerException("StackifyErrorConverter is null");
        }
        this.errorConverter = errorWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(String apiUrl, String apiKey, List<StackifyError> errors) throws IOException {
        int n;
        if (apiUrl == null) {
            throw new NullPointerException("API URL is null");
        }
        if (apiUrl.isEmpty()) {
            throw new IllegalArgumentException("API URL is empty");
        }
        if (apiKey == null) {
            throw new NullPointerException("API key is null");
        }
        if (apiKey.isEmpty()) {
            throw new IllegalArgumentException("API key is empty");
        }
        if (errors == null) {
            throw new NullPointerException("StackifyError list is null");
        }
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("StackifyError list is empty");
        }
        HttpURLConnection connection = null;
        try {
            URL url = new URL(apiUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Encoding", "gzip");
            connection.setRequestProperty("X-Stackify-Key", apiKey);
            connection.setRequestProperty("X-Stackify-PV", "V1");
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            BufferedOutputStream stream = new BufferedOutputStream(new GZIPOutputStream(connection.getOutputStream()));
            this.errorConverter.writeToStream(errors, (OutputStream)stream);
            ((OutputStream)stream).flush();
            ((OutputStream)stream).close();
            n = connection.getResponseCode();
        }
        catch (Throwable throwable) {
            HttpUrlConnections.readAndCloseInputStreams(connection);
            throw throwable;
        }
        HttpUrlConnections.readAndCloseInputStreams(connection);
        return n;
    }
}

