/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.stackify.api.common.http.AsyncErrorSender;
import com.stackify.api.common.http.AsyncScheduler;
import com.stackify.api.common.http.HttpTransmissionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncErrorSenderService
extends AbstractScheduledService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncErrorSenderService.class);
    private final AsyncScheduler scheduler;
    private final AsyncErrorSender asyncErrorSender;

    public AsyncErrorSenderService(AsyncScheduler scheduler, AsyncErrorSender asyncErrorSender) {
        Preconditions.checkNotNull((Object)((Object)scheduler), (Object)"AsyncScheduler can't be null");
        Preconditions.checkNotNull((Object)asyncErrorSender, (Object)"AsyncErrorSender can't be null");
        this.scheduler = scheduler;
        this.asyncErrorSender = asyncErrorSender;
    }

    protected String serviceName() {
        return "Stackify_AsyncErrorSenderService";
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return this.scheduler;
    }

    protected void startUp() throws Exception {
        super.startUp();
    }

    protected void shutDown() throws Exception {
        LOGGER.debug("Shutting down Stackify_AsyncErrorSenderService");
        try {
            this.asyncErrorSender.flush();
        }
        catch (Exception e) {
            LOGGER.info("Exception running Stackify_AsyncErrorSenderService", (Throwable)e);
        }
        super.shutDown();
    }

    protected void runOneIteration() {
        try {
            HttpTransmissionStatus status = this.asyncErrorSender.flush();
            this.scheduler.update(status);
        }
        catch (Exception e) {
            LOGGER.info("Exception running Stackify_AsyncErrorSenderService", (Throwable)e);
            this.scheduler.update(HttpTransmissionStatus.ERROR);
        }
    }
}

