/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.stackify.api.AppIdentity;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.common.AppIdentityService;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.log.LogSender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class LogCollector {
    private final String logger;
    private final EnvironmentDetail envDetail;
    private final AppIdentityService appIdentityService;
    private final Queue<LogMsg> queue = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)1000));

    public LogCollector(String logger, EnvironmentDetail envDetail, AppIdentityService appIdentityService) {
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkNotNull((Object)envDetail);
        Preconditions.checkNotNull((Object)appIdentityService);
        this.logger = logger;
        this.envDetail = envDetail;
        this.appIdentityService = appIdentityService;
    }

    public void addLogMsg(LogMsg logMsg) {
        Preconditions.checkNotNull((Object)logMsg);
        this.queue.offer(logMsg);
    }

    public int flush(LogSender sender) throws IOException, HttpException {
        int numSent;
        int maxToSend = this.queue.size();
        if (0 < maxToSend) {
            int batchSize;
            Optional<AppIdentity> appIdentity = this.appIdentityService.getAppIdentity();
            for (numSent = 0; numSent < maxToSend; numSent += batchSize) {
                batchSize = Math.min(maxToSend - numSent, 20);
                ArrayList batch = Lists.newArrayListWithCapacity((int)batchSize);
                for (int i = 0; i < batchSize; ++i) {
                    batch.add(this.queue.remove());
                }
                LogMsgGroup.Builder groupBuilder = LogMsgGroup.newBuilder();
                groupBuilder.platform("java");
                groupBuilder.logger(this.logger);
                groupBuilder.serverName(this.envDetail.getDeviceName());
                if (appIdentity.isPresent()) {
                    groupBuilder.cdId(((AppIdentity)appIdentity.get()).getDeviceId());
                    groupBuilder.cdAppId(((AppIdentity)appIdentity.get()).getDeviceAppId());
                    groupBuilder.appNameId(((AppIdentity)appIdentity.get()).getAppNameId());
                    groupBuilder.envId(((AppIdentity)appIdentity.get()).getEnvId());
                } else {
                    groupBuilder.appName(this.envDetail.getConfiguredAppName());
                    groupBuilder.appLoc(this.envDetail.getAppLocation());
                    groupBuilder.env(this.envDetail.getConfiguredEnvironmentName());
                }
                groupBuilder.msgs((List)batch);
                LogMsgGroup group = groupBuilder.build();
                int httpStatus = sender.send(group);
                if (httpStatus == 200) continue;
                throw new HttpException(httpStatus);
            }
        }
        return numSent;
    }
}

