/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.error.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import com.stackify.api.ApiClient;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.StackifyError;
import com.stackify.api.common.ApiClients;
import com.stackify.api.common.EnvironmentDetails;
import com.stackify.api.common.http.StackifyErrorSender;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.json.StackifyErrorConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class StackifyErrorAppender
extends AppenderBase<ILoggingEvent> {
    private StackifyErrorSender errorSender;
    private ApiClient apiClient = null;
    private EnvironmentDetail environmentDetail = null;
    private String apiUrl = "https://api.stackify.com/Error/V1";
    private String apiKey = null;
    private String application = null;
    private String environment = null;
    private String converter = "com.stackify.api.json.jackson.StackifyErrorJacksonConverter";

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getConverter() {
        return this.converter;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    protected StackifyErrorSender getErrorSender() {
        return this.errorSender;
    }

    protected ApiClient getApiClient() {
        return this.apiClient;
    }

    protected EnvironmentDetail getEnvironmentDetail() {
        return this.environmentDetail;
    }

    public void start() {
        super.start();
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            this.addError("API Key not set for the Stackify Error Appender");
            return;
        }
        this.apiClient = ApiClients.getApiClient(StackifyErrorAppender.class, (String)"/stackify-error-logback.properties");
        this.environmentDetail = EnvironmentDetails.getEnvironmentDetail((String)this.application, (String)this.environment);
        try {
            Class<?> converterClass = Class.forName(this.converter);
            StackifyErrorConverter converterInstance = (StackifyErrorConverter)converterClass.newInstance();
            this.errorSender = new StackifyErrorSender(converterInstance);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void append(ILoggingEvent event) {
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            return;
        }
        Throwable exception = this.getThrowable(event);
        if (exception == null) {
            if (event.getLevel() == Level.ERROR) {
                exception = new Throwable();
            } else {
                return;
            }
        }
        try {
            ArrayList<String> tags = new ArrayList<String>();
            tags.add("logback");
            tags.add(event.getLevel().toString().toLowerCase());
            tags.add(event.getLoggerName());
            StackifyError.Builder errorBuilder = StackifyError.newBuilder();
            errorBuilder.apiClient(this.apiClient);
            errorBuilder.environmentDetail(this.environmentDetail);
            errorBuilder.occurredEpochMillis(new Date(event.getTimeStamp()));
            errorBuilder.error(Throwables.toErrorItem((Throwable)exception));
            errorBuilder.tags(tags);
            StackifyError error = errorBuilder.build();
            int rc = this.errorSender.send(this.apiUrl, this.apiKey, Collections.singletonList(error));
            if (rc != 200) {
                this.addInfo("Stackify Error Service returned HTTP " + Integer.toString(rc));
            }
        }
        catch (Throwable t) {
            this.addInfo("Exception posting to Stackify Error Service", t);
        }
    }

    private Throwable getThrowable(ILoggingEvent event) {
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null && iThrowableProxy instanceof ThrowableProxy) {
            ThrowableProxy throwableProxy = (ThrowableProxy)iThrowableProxy;
            return throwableProxy.getThrowable();
        }
        return null;
    }
}

