/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.google.gson.Gson;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.net.HttpHelper;
import com.stackmob.sdk.net.HttpVerb;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;

public class StackMobRequest {
    public static final String DEFAULT_URL_FORMAT = "api.mob1.stackmob.com";
    protected static final String SECURE_SCHEME = "https";
    protected static final String REGULAR_SCHEME = "http";
    protected final StackMobSession session;
    protected final String sessionKey;
    protected final StackMobRedirectedCallback redirectedCallback;
    protected final String sessionSecret;
    protected String methodName;
    protected String urlFormat = "api.mob1.stackmob.com";
    protected Boolean isSecure = true;
    protected HttpVerb httpMethod = HttpVerb.GET;
    protected Map<String, Object> params;
    protected Object requestObject;
    protected StackMobCallback callback = new StackMobCallback(){

        @Override
        public void success(String s) {
        }

        @Override
        public void failure(StackMobException e) {
        }
    };

    private StackMobRequest(StackMobSession session, String method, StackMobRedirectedCallback redirCB) {
        this.session = session;
        this.sessionKey = session.getKey();
        this.sessionSecret = session.getSecret();
        this.methodName = method;
        this.redirectedCallback = redirCB;
    }

    public StackMobRequest(StackMobSession session, String method, StackMobCallback callback, StackMobRedirectedCallback redirCB) {
        this(session, method, redirCB);
        this.callback = callback;
    }

    public StackMobRequest(StackMobSession session, String method, Map<String, Object> args, StackMobCallback callback, StackMobRedirectedCallback redirCB) {
        this(session, method, callback, redirCB);
        this.params = args;
    }

    public StackMobRequest(StackMobSession session, String method, HttpVerb verb, Object requestObject, StackMobCallback callback, StackMobRedirectedCallback redirCB) {
        this(session, method, verb, callback, redirCB);
        this.requestObject = requestObject;
    }

    public StackMobRequest(StackMobSession session, String method, HttpVerb verb, StackMobCallback callback, StackMobRedirectedCallback redirCB) {
        this(session, method, callback, redirCB);
        this.methodName = method;
        this.httpMethod = verb;
    }

    public StackMobRequest setUrlFormat(String urlFmt) {
        this.urlFormat = urlFmt;
        return this;
    }

    public void sendRequest() {
        try {
            String response = null;
            switch (this.httpMethod) {
                case GET: {
                    response = this.sendGetRequest();
                    break;
                }
                case POST: {
                    response = this.sendPostRequest();
                    break;
                }
                case PUT: {
                    response = this.sendPutRequest();
                    break;
                }
                case DELETE: {
                    response = this.sendDeleteRequest();
                }
            }
            this.callback.success(response);
        }
        catch (StackMobException e) {
            this.callback.failure(e);
        }
    }

    private String sendGetRequest() throws StackMobException {
        String ret;
        try {
            String query = null;
            if (null != this.params) {
                query = URLEncodedUtils.format(this.getParamsForRequest(), (String)"UTF-8");
            }
            URI uri = URIUtils.createURI((String)this.getScheme(), (String)this.getHost(), (int)-1, (String)this.getPath(), (String)query, null);
            ret = HttpHelper.doGet(uri, this.sessionKey, this.sessionSecret, this.redirectedCallback);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        return ret;
    }

    private String sendPostRequest() throws StackMobException {
        String ret;
        try {
            URI uri = URIUtils.createURI((String)this.getScheme(), (String)this.getHost(), (int)-1, (String)this.getPath(), null, null);
            UrlEncodedFormEntity entity = null;
            if (null != this.params) {
                entity = new UrlEncodedFormEntity(this.getParamsForRequest(), "UTF-8");
            } else if (null != this.requestObject) {
                Gson gson = new Gson();
                entity = new StringEntity(gson.toJson(this.requestObject), "UTF-8");
            }
            ret = HttpHelper.doPost(uri, (HttpEntity)entity, this.sessionKey, this.sessionSecret, this.redirectedCallback);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new StackMobException(e.getMessage());
        }
        return ret;
    }

    private String sendPutRequest() throws StackMobException {
        String ret;
        try {
            URI uri = URIUtils.createURI((String)this.getScheme(), (String)this.getHost(), (int)-1, (String)this.getPath(), null, null);
            UrlEncodedFormEntity entity = null;
            if (null != this.params) {
                entity = new UrlEncodedFormEntity(this.getParamsForRequest(), "UTF-8");
            } else if (null != this.requestObject) {
                Gson gson = new Gson();
                entity = new StringEntity(gson.toJson(this.requestObject), "UTF-8");
            }
            ret = HttpHelper.doPut(uri, (HttpEntity)entity, this.sessionKey, this.sessionSecret, this.redirectedCallback);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new StackMobException(e.getMessage());
        }
        return ret;
    }

    private String sendDeleteRequest() throws StackMobException {
        String ret;
        try {
            String query = null;
            if (null != this.params) {
                query = URLEncodedUtils.format(this.getParamsForRequest(), (String)"UTF-8");
            }
            URI uri = URIUtils.createURI((String)this.getScheme(), (String)this.getHost(), (int)-1, (String)this.getPath(), (String)query, null);
            ret = HttpHelper.doDelete(uri, this.sessionKey, this.sessionSecret, this.redirectedCallback);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        return ret;
    }

    protected String getPath() {
        return "/" + this.methodName;
    }

    private String getScheme() {
        if (this.isSecure.booleanValue()) {
            return SECURE_SCHEME;
        }
        return REGULAR_SCHEME;
    }

    private String getHost() {
        return this.urlFormat;
    }

    private List<NameValuePair> getParamsForRequest() {
        if (null == this.params) {
            return null;
        }
        ArrayList<NameValuePair> ret = new ArrayList<NameValuePair>(this.params.size());
        for (String key : this.params.keySet()) {
            ret.add((NameValuePair)new BasicNameValuePair(key, this.params.get(key).toString()));
        }
        return ret;
    }
}

