/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.net.HttpRedirectHelper;
import com.stackmob.sdk.net.HttpVerb;
import com.stackmob.sdk.net.HttpVerbHelper;
import com.stackmob.sdk.net.HttpVerbWithPayload;
import com.stackmob.sdk.net.HttpVerbWithoutPayload;
import com.stackmob.sdk.net.StackMobApi;
import com.stackmob.sdk.push.StackMobPushToken;
import com.stackmob.sdk.push.StackMobPushTokenDeserializer;
import com.stackmob.sdk.push.StackMobPushTokenSerializer;
import com.stackmob.sdk.util.JsonError;
import com.stackmob.sdk.util.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.scribe.builder.ServiceBuilder;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;

public abstract class StackMobRequest {
    public static final Map<String, String> EmptyHeaders = new HashMap<String, String>();
    public static final Map<String, String> EmptyParams = new HashMap<String, String>();
    public static final String DEFAULT_URL_FORMAT = "mob1.stackmob.com";
    public static final String DEFAULT_API_URL_FORMAT = "api.mob1.stackmob.com";
    public static final String DEFAULT_PUSH_URL_FORMAT = "push.mob1.stackmob.com";
    protected static final String SECURE_SCHEME = "https";
    protected static final String REGULAR_SCHEME = "http";
    private static final ConcurrentHashMap<String, Pair<String, Date>> cookies = new ConcurrentHashMap();
    private static final String SetCookieHeaderKey = "Set-Cookie";
    private static final DateFormat cookieDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");
    private static final String EXPIRES = "Expires";
    protected final ExecutorService executor;
    protected final StackMobSession session;
    protected StackMobCallback callback;
    protected final StackMobRedirectedCallback redirectedCallback;
    protected HttpVerb httpVerb;
    protected String methodName;
    protected String urlFormat = "api.mob1.stackmob.com";
    protected Boolean isSecure = false;
    protected Map<String, String> params;
    protected Map<String, String> headers;
    protected Gson gson;
    private OAuthService oAuthService;

    protected StackMobRequest(ExecutorService executor, StackMobSession session, HttpVerb verb, Map<String, String> headers, Map<String, String> params, String method, StackMobCallback cb, StackMobRedirectedCallback redirCb) {
        this.executor = executor;
        this.session = session;
        this.httpVerb = verb;
        this.headers = headers;
        this.params = params;
        this.methodName = method;
        this.callback = cb;
        this.redirectedCallback = redirCb;
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(StackMobPushToken.class, (Object)new StackMobPushTokenDeserializer()).registerTypeAdapter(StackMobPushToken.class, (Object)new StackMobPushTokenSerializer()).excludeFieldsWithModifiers(new int[]{2, 4, 128, 8});
        this.gson = gsonBuilder.create();
        this.oAuthService = new ServiceBuilder().provider(StackMobApi.class).apiKey(session.getKey()).apiSecret(session.getSecret()).build();
    }

    public StackMobRequest setUrlFormat(String urlFmt) {
        this.urlFormat = urlFmt;
        return this;
    }

    protected abstract String getRequestBody();

    public void sendRequest() {
        try {
            if (HttpVerbWithoutPayload.GET == this.httpVerb) {
                this.sendGetRequest();
            } else if (HttpVerbWithPayload.POST == this.httpVerb) {
                this.sendPostRequest();
            } else if (HttpVerbWithPayload.PUT == this.httpVerb) {
                this.sendPutRequest();
            } else if (HttpVerbWithoutPayload.DELETE == this.httpVerb) {
                this.sendDeleteRequest();
            }
        }
        catch (StackMobException e) {
            this.callback.failure(e);
        }
    }

    private void sendGetRequest() throws StackMobException {
        try {
            String query = StackMobRequest.formatQueryString(this.params);
            URI uri = this.createURI(this.getScheme(), this.urlFormat, this.getPath(), query);
            OAuthRequest req = this.getOAuthRequest(HttpVerbWithoutPayload.GET, uri.toString());
            this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    private void sendPostRequest() throws StackMobException {
        try {
            URI uri = this.createURI(this.getScheme(), this.urlFormat, this.getPath(), "");
            String payload = this.getRequestBody();
            OAuthRequest req = this.getOAuthRequest(HttpVerbWithPayload.POST, uri.toString(), payload);
            this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    private void sendPutRequest() throws StackMobException {
        try {
            URI uri = this.createURI(this.getScheme(), this.urlFormat, this.getPath(), "");
            String payload = this.getRequestBody();
            OAuthRequest req = this.getOAuthRequest(HttpVerbWithPayload.PUT, uri.toString(), payload);
            this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    private void sendDeleteRequest() throws StackMobException {
        try {
            String query = StackMobRequest.formatQueryString(this.params);
            URI uri = this.createURI(this.getScheme(), this.urlFormat, this.getPath(), query);
            OAuthRequest req = this.getOAuthRequest(HttpVerbWithoutPayload.DELETE, uri.toString());
            this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    private URI createURI(String scheme, String host, String path, String query) throws URISyntaxException {
        StringBuilder uriBuilder = new StringBuilder().append(scheme).append("://").append(host);
        if (!path.startsWith("/")) {
            uriBuilder.append("/");
        }
        uriBuilder.append(path);
        if (query != null && query.length() > 0) {
            uriBuilder.append("?").append(query);
        }
        return new URI(uriBuilder.toString());
    }

    protected String getPath() {
        if (this.methodName.startsWith("/")) {
            return this.methodName;
        }
        return "/" + this.methodName;
    }

    private String getScheme() {
        if (this.isSecure.booleanValue()) {
            return SECURE_SCHEME;
        }
        return REGULAR_SCHEME;
    }

    private static String percentEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
    }

    protected static String formatQueryString(Map<String, String> params) {
        StringBuilder formatBuilder = new StringBuilder();
        boolean first = true;
        for (String key : params.keySet()) {
            if (!first) {
                formatBuilder.append("&");
            }
            first = false;
            String value = params.get(key);
            try {
                formatBuilder.append(StackMobRequest.percentEncode(key)).append("=").append(StackMobRequest.percentEncode(value));
            }
            catch (UnsupportedEncodingException e) {}
        }
        return formatBuilder.toString();
    }

    private OAuthRequest getOAuthRequest(HttpVerb method, String url) {
        OAuthRequest oReq = new OAuthRequest(Verb.valueOf((String)method.toString()), url);
        int apiVersion = this.session.getApiVersionNumber();
        String contentType = "application/vnd.stackmob+json;";
        String accept = "application/vnd.stackmob+json; version=" + apiVersion;
        String userAgentIntermediate = "StackMob Java Client; " + apiVersion;
        if (this.session.getAppName() != null) {
            userAgentIntermediate = userAgentIntermediate + "/" + this.session.getAppName();
        }
        String userAgent = userAgentIntermediate;
        ArrayList<Pair<String, String>> headerList = new ArrayList<Pair<String, String>>();
        headerList.add(new Pair<String, String>("Content-Type", "application/vnd.stackmob+json;"));
        headerList.add(new Pair<String, String>("Accept", accept));
        headerList.add(new Pair<String, String>("User-Agent", userAgent));
        Set<Map.Entry<String, Pair<String, Date>>> cookiesSet = cookies.entrySet();
        StringBuilder cookieBuilder = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Pair<String, Date>> entry : cookiesSet) {
            if (!first) {
                cookieBuilder.append("; ");
            }
            first = false;
            Date expires = entry.getValue().getSecond();
            if (expires != null && new Date().compareTo(expires) != 1) continue;
            cookieBuilder.append(entry.getKey()).append("=").append(entry.getValue().getFirst());
        }
        headerList.add(new Pair<String, String>("Cookie", cookieBuilder.toString()));
        if (this.headers != null) {
            for (String string : this.headers.keySet()) {
                headerList.add(new Pair<String, String>(string, this.headers.get(string)));
            }
        }
        for (Pair pair : headerList) {
            oReq.addHeader((String)pair.getFirst(), (String)pair.getSecond());
        }
        this.oAuthService.signRequest(new Token("", ""), oReq);
        return oReq;
    }

    private OAuthRequest getOAuthRequest(HttpVerb method, String url, String payload) {
        OAuthRequest req = this.getOAuthRequest(method, url);
        req.addPayload(payload);
        return req;
    }

    private void storeCookies(Response resp) {
        for (String key : resp.getHeaders().keySet()) {
            String[] cookieSplit;
            if (key == null || !key.equalsIgnoreCase(SetCookieHeaderKey)) continue;
            String val = (String)resp.getHeaders().get(key);
            String[] valSplit = val.split(";");
            if (valSplit.length == 1) {
                cookieSplit = val.split("=");
                if (cookieSplit.length != 2) continue;
                cookies.put(valSplit[0], new Pair<String, Object>(valSplit[1], null));
                continue;
            }
            if (valSplit.length != 2) continue;
            cookieSplit = valSplit[0].split("=");
            String[] expiresSplit = valSplit[1].split("=");
            Date expires = null;
            if (expiresSplit.length != 2 || cookieSplit.length != 2) continue;
            if (expiresSplit[0].equals(EXPIRES)) {
                try {
                    expires = cookieDateFormat.parse(expiresSplit[1]);
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            cookies.put(cookieSplit[0], new Pair<String, Date>(cookieSplit[1], expires));
        }
    }

    private void sendRequest(final OAuthRequest req) throws InterruptedException, ExecutionException {
        final StackMobCallback cb = this.callback;
        this.executor.submit(new Callable<Object>(){

            @Override
            public String call() throws Exception {
                Response ret = req.send();
                if (HttpRedirectHelper.isRedirected(ret.getCode())) {
                    try {
                        String newLocation = HttpRedirectHelper.getNewLocation(ret.getHeaders());
                        HttpVerb verb = HttpVerbHelper.valueOf(req.getVerb().toString());
                        OAuthRequest newReq = StackMobRequest.this.getOAuthRequest(verb, newLocation);
                        if (req.getBodyContents() != null && req.getBodyContents().length() > 0) {
                            newReq = StackMobRequest.this.getOAuthRequest(verb, newLocation, req.getBodyContents());
                        }
                        StackMobRequest.this.redirectedCallback.redirected(req.getUrl(), ret.getHeaders(), ret.getBody(), newReq.getUrl());
                        StackMobRequest.this.sendRequest(newReq);
                    }
                    catch (Exception e) {
                        StackMobRequest.this.callback.failure(new StackMobException(e.getMessage()));
                    }
                } else {
                    JsonError err = null;
                    try {
                        err = (JsonError)StackMobRequest.this.gson.fromJson(ret.getBody(), JsonError.class);
                    }
                    catch (JsonSyntaxException e) {
                    }
                    catch (JsonParseException jsonParseException) {
                        // empty catch block
                    }
                    if (err != null && err.error != null) {
                        cb.failure(new StackMobException(err.error));
                    } else {
                        StackMobRequest.this.storeCookies(ret);
                        cb.success(ret.getBody());
                    }
                }
                return null;
            }
        });
    }
}

