/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.util;

import java.util.HashMap;
import java.util.Map;

public class RelationMapping {
    private Map<String, String> relations = new HashMap<String, String>();
    private String basePath = "";

    public void add(String path, String schemaName) {
        String newPath = this.basePath + path;
        this.relations.put(newPath, schemaName);
        this.basePath = newPath + ".";
    }

    public void leave() {
        this.basePath = this.basePath.substring(0, this.basePath.lastIndexOf(".", this.basePath.length() - 2) + 1);
    }

    public boolean isEmpty() {
        return this.relations.isEmpty();
    }

    public String toHeaderString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.relations.entrySet()) {
            if (!first) {
                sb.append("&");
            }
            first = false;
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        return sb.toString();
    }
}

