/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.callback;

import com.stackmob.sdk.net.HttpVerb;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class StackMobRawCallback {
    protected HttpVerb requestVerb;
    protected String requestURL;
    protected List<Map.Entry<String, String>> requestHeaders;
    protected String requestBody;
    protected Integer responseStatusCode;
    protected List<Map.Entry<String, String>> responseHeaders;
    protected byte[] responseBody;

    public void setDone(HttpVerb requestVerb, String requestURL, List<Map.Entry<String, String>> requestHeaders, String requestBody, Integer responseStatusCode, List<Map.Entry<String, String>> responseHeaders, byte[] responseBody) {
        this.requestVerb = requestVerb;
        this.requestURL = requestURL;
        this.requestHeaders = requestHeaders;
        this.requestBody = requestBody;
        this.responseStatusCode = responseStatusCode;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.done(requestVerb, requestURL, requestHeaders, requestBody, responseStatusCode, responseHeaders, responseBody);
    }

    public abstract void done(HttpVerb var1, String var2, List<Map.Entry<String, String>> var3, String var4, Integer var5, List<Map.Entry<String, String>> var6, byte[] var7);

    public int getTotalObjectCountFromPagination() {
        return StackMobRawCallback.getTotalNumberOfItemsFromContentRange(this.responseHeaders);
    }

    public static Integer getTotalNumberOfItemsFromContentRange(List<Map.Entry<String, String>> responseHeaders) {
        if (responseHeaders == null) {
            return -1;
        }
        Map.Entry<String, String> contentLengthHeader = null;
        for (Map.Entry<String, String> header : responseHeaders) {
            if (header.getKey() == null || !header.getKey().toLowerCase().equals("content-range")) continue;
            contentLengthHeader = header;
        }
        if (contentLengthHeader != null) {
            List<String> hyphenSplit = Arrays.asList(((String)contentLengthHeader.getValue()).split("\\-"));
            if (hyphenSplit.size() != 2) {
                return -1;
            }
            List<String> slashSplit = Arrays.asList(hyphenSplit.get(1).split("/"));
            if (slashSplit.size() != 2) {
                return -1;
            }
            String instanceLengthString = slashSplit.get(1).trim();
            if (instanceLengthString.equals("*")) {
                return -2;
            }
            try {
                return Integer.parseInt(instanceLengthString);
            }
            catch (Throwable t) {
                return -1;
            }
        }
        return -1;
    }
}

