/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.push;

import com.stackmob.sdk.api.StackMob;
import com.stackmob.sdk.api.StackMobOptions;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.net.HttpVerbWithoutPayload;
import com.stackmob.sdk.push.StackMobPushToken;
import com.stackmob.sdk.request.StackMobPushRequest;
import com.stackmob.sdk.request.StackMobRequestWithoutPayload;
import com.stackmob.sdk.util.Pair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class StackMobPush {
    public static String DEFAULT_PUSH_HOST = "push.stackmob.com";
    private ExecutorService executor;
    private StackMobSession session;
    private String host;
    private StackMobRedirectedCallback redirectedCallback;
    private static StackMobPush push;

    public static void setPushType(StackMobPushToken.TokenType type) {
        StackMobPushToken.setPushType(type);
    }

    public static StackMobPush getPush() {
        return push;
    }

    public static void setPush(StackMobPush push) {
        StackMobPush.push = push;
    }

    public StackMobPush(int apiVersionNumber, String apiKey, String apiSecret) {
        this(apiVersionNumber, apiKey, apiSecret, DEFAULT_PUSH_HOST, StackMob.DEFAULT_REDIRECTED_CALLBACK);
        new StackMob(StackMob.OAuthVersion.One, apiVersionNumber, apiKey, apiSecret);
    }

    public StackMobPush(int apiVersionNumber, String apiKey, String apiSecret, String host, StackMobRedirectedCallback redirectedCallback) {
        this.executor = Executors.newCachedThreadPool();
        this.session = new StackMobSession(StackMob.OAuthVersion.One, apiVersionNumber, apiKey, apiSecret, StackMob.DEFAULT_USER_SCHEMA_NAME, StackMob.DEFAULT_USER_ID);
        this.host = host;
        this.redirectedCallback = redirectedCallback;
        if (push == null) {
            push = this;
        }
    }

    public StackMobPush(StackMob stackmob) {
        this(stackmob, DEFAULT_PUSH_HOST);
    }

    public StackMobPush(StackMob stackmob, String host) {
        this.executor = stackmob.getExecutor();
        this.session = stackmob.getSession();
        this.host = host;
        this.redirectedCallback = stackmob.getRedirectedCallback();
        if (push == null) {
            push = this;
        }
    }

    public void pushToTokens(Map<String, String> payload, List<StackMobPushToken> tokens, StackMobRawCallback callback) {
        HashMap<String, Object> finalPayload = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> payloadMap = new HashMap<String, Map<String, String>>();
        payloadMap.put("kvPairs", payload);
        finalPayload.put("payload", payloadMap);
        finalPayload.put("tokens", tokens);
        this.postPush("push_tokens_universal", finalPayload, callback);
    }

    public void pushToUsers(Map<String, String> payload, List<String> userIds, StackMobRawCallback callback) {
        HashMap<String, Object> finalPayload = new HashMap<String, Object>();
        finalPayload.put("kvPairs", payload);
        finalPayload.put("userIds", userIds);
        this.postPush("push_users_universal", finalPayload, callback);
    }

    public void registerForPushWithUser(StackMobPushToken token, String username, StackMobRawCallback callback) {
        this.registerForPushWithUser(token, username, false, callback);
    }

    public void registerForPushWithUser(StackMobPushToken token, String username, boolean overwrite, StackMobRawCallback callback) {
        RegistrationIDAndUser tokenAndUser = new RegistrationIDAndUser(token, username, overwrite);
        this.postPush("register_device_token_universal", tokenAndUser, callback);
    }

    public void getTokensForUsers(List<String> usernames, StackMobRawCallback callback) {
        StringBuilder userIds = new StringBuilder();
        boolean first = true;
        for (String username : usernames) {
            if (!first) {
                userIds.append(",");
            }
            first = false;
            userIds.append(username);
        }
        LinkedList<Map.Entry<String, String>> params = new LinkedList<Map.Entry<String, String>>();
        params.add(new Pair<String, String>("userIds", userIds.toString()));
        this.getPush("get_tokens_for_users_universal", params, callback);
    }

    public void broadcastPushNotification(Map<String, String> payload, StackMobRawCallback callback) {
        HashMap<String, Map<String, String>> finalPayload = new HashMap<String, Map<String, String>>();
        finalPayload.put("kvPairs", payload);
        this.postPush("push_broadcast", finalPayload, callback);
    }

    public void removePushToken(StackMobPushToken token, StackMobRawCallback callback) {
        HashMap<String, String> finalPayload = new HashMap<String, String>();
        finalPayload.put("token", token.getToken());
        finalPayload.put("type", token.getTokenType().toString());
        this.postPush("remove_token_universal", finalPayload, callback);
    }

    private void postPush(String path, Object requestObject, StackMobRawCallback callback) {
        new StackMobPushRequest(this.executor, this.session, requestObject, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    private void getPush(String path, List<Map.Entry<String, String>> arguments, StackMobRawCallback callback) {
        new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.GET, StackMobOptions.none(), arguments, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    private class RegistrationIDAndUser {
        public String userId;
        public Map<String, String> token = new HashMap<String, String>();
        public Boolean overwrite = null;

        public RegistrationIDAndUser(StackMobPushToken token, String user) {
            this.userId = user;
            this.token.put("token", token.getToken());
            this.token.put("type", token.getTokenType().toString());
        }

        public RegistrationIDAndUser(StackMobPushToken token, String user, boolean overwrite) {
            this(token, user);
            this.overwrite = overwrite;
        }
    }
}

