/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.IamPoliciesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class IamListPoliciesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends IamPoliciesPaginated> iamPoliciesPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<IamListPoliciesResponse>> next = () -> Optional.empty();

    @JsonCreator
    public IamListPoliciesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends IamPoliciesPaginated> iamPoliciesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(iamPoliciesPaginated, "iamPoliciesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.iamPoliciesPaginated = iamPoliciesPaginated;
        this.headers = headers;
    }

    public IamListPoliciesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<IamPoliciesPaginated> iamPoliciesPaginated() {
        return this.iamPoliciesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<IamListPoliciesResponse> next() throws Exception {
        return this.next.call();
    }

    private IamListPoliciesResponse withNext(Callable<Optional<IamListPoliciesResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public IamListPoliciesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public IamListPoliciesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public IamListPoliciesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public IamListPoliciesResponse withIamPoliciesPaginated(IamPoliciesPaginated iamPoliciesPaginated) {
        Utils.checkNotNull(iamPoliciesPaginated, "iamPoliciesPaginated");
        this.iamPoliciesPaginated = Optional.ofNullable(iamPoliciesPaginated);
        return this;
    }

    public IamListPoliciesResponse withIamPoliciesPaginated(Optional<? extends IamPoliciesPaginated> iamPoliciesPaginated) {
        Utils.checkNotNull(iamPoliciesPaginated, "iamPoliciesPaginated");
        this.iamPoliciesPaginated = iamPoliciesPaginated;
        return this;
    }

    public IamListPoliciesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamListPoliciesResponse other = (IamListPoliciesResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.iamPoliciesPaginated, other.iamPoliciesPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.iamPoliciesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(IamListPoliciesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "iamPoliciesPaginated", this.iamPoliciesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<IamListPoliciesResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends IamPoliciesPaginated> iamPoliciesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder iamPoliciesPaginated(IamPoliciesPaginated iamPoliciesPaginated) {
            Utils.checkNotNull(iamPoliciesPaginated, "iamPoliciesPaginated");
            this.iamPoliciesPaginated = Optional.ofNullable(iamPoliciesPaginated);
            return this;
        }

        public Builder iamPoliciesPaginated(Optional<? extends IamPoliciesPaginated> iamPoliciesPaginated) {
            Utils.checkNotNull(iamPoliciesPaginated, "iamPoliciesPaginated");
            this.iamPoliciesPaginated = iamPoliciesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<IamListPoliciesResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public IamListPoliciesResponse build() {
            return new IamListPoliciesResponse(this.contentType, this.statusCode, this.rawResponse, this.iamPoliciesPaginated, this.headers).withNext(this.next);
        }
    }
}

