/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Role
 * 
 * <p>The role of manager
 */
public class Role {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The label of the role type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("label")
    private JsonNullable<String> label;

    /**
     * The manager role type (e.g., admin, viewer)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("role_type")
    private JsonNullable<? extends RoleType> roleType;

    @JsonCreator
    public Role(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("label") JsonNullable<String> label,
            @JsonProperty("role_type") JsonNullable<? extends RoleType> roleType) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(roleType, "roleType");
        this.id = id;
        this.remoteId = remoteId;
        this.label = label;
        this.roleType = roleType;
    }
    
    public Role() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The label of the role type
     */
    @JsonIgnore
    public JsonNullable<String> label() {
        return label;
    }

    /**
     * The manager role type (e.g., admin, viewer)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<RoleType> roleType() {
        return (JsonNullable<RoleType>) roleType;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public Role withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Role withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Role withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Role withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The label of the role type
     */
    public Role withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of(label);
        return this;
    }

    /**
     * The label of the role type
     */
    public Role withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    /**
     * The manager role type (e.g., admin, viewer)
     */
    public Role withRoleType(RoleType roleType) {
        Utils.checkNotNull(roleType, "roleType");
        this.roleType = JsonNullable.of(roleType);
        return this;
    }

    /**
     * The manager role type (e.g., admin, viewer)
     */
    public Role withRoleType(JsonNullable<? extends RoleType> roleType) {
        Utils.checkNotNull(roleType, "roleType");
        this.roleType = roleType;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Role other = (Role) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.label, other.label) &&
            Utils.enhancedDeepEquals(this.roleType, other.roleType);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, label,
            roleType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Role.class,
                "id", id,
                "remoteId", remoteId,
                "label", label,
                "roleType", roleType);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> label = JsonNullable.undefined();

        private JsonNullable<? extends RoleType> roleType = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The label of the role type
         */
        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of(label);
            return this;
        }

        /**
         * The label of the role type
         */
        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }


        /**
         * The manager role type (e.g., admin, viewer)
         */
        public Builder roleType(RoleType roleType) {
            Utils.checkNotNull(roleType, "roleType");
            this.roleType = JsonNullable.of(roleType);
            return this;
        }

        /**
         * The manager role type (e.g., admin, viewer)
         */
        public Builder roleType(JsonNullable<? extends RoleType> roleType) {
            Utils.checkNotNull(roleType, "roleType");
            this.roleType = roleType;
            return this;
        }

        public Role build() {

            return new Role(
                id, remoteId, label,
                roleType);
        }

    }
}
