/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ScorecardsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListApplicationScorecardsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ScorecardsPaginated> scorecardsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListApplicationScorecardsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ScorecardsPaginated> scorecardsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(scorecardsPaginated, "scorecardsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.scorecardsPaginated = scorecardsPaginated;
        this.headers = headers;
    }

    public AtsListApplicationScorecardsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ScorecardsPaginated> scorecardsPaginated() {
        return this.scorecardsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsListApplicationScorecardsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListApplicationScorecardsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListApplicationScorecardsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListApplicationScorecardsResponse withScorecardsPaginated(ScorecardsPaginated scorecardsPaginated) {
        Utils.checkNotNull(scorecardsPaginated, "scorecardsPaginated");
        this.scorecardsPaginated = Optional.ofNullable(scorecardsPaginated);
        return this;
    }

    public AtsListApplicationScorecardsResponse withScorecardsPaginated(Optional<? extends ScorecardsPaginated> scorecardsPaginated) {
        Utils.checkNotNull(scorecardsPaginated, "scorecardsPaginated");
        this.scorecardsPaginated = scorecardsPaginated;
        return this;
    }

    public AtsListApplicationScorecardsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListApplicationScorecardsResponse other = (AtsListApplicationScorecardsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.scorecardsPaginated, other.scorecardsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.scorecardsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListApplicationScorecardsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "scorecardsPaginated", this.scorecardsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ScorecardsPaginated> scorecardsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder scorecardsPaginated(ScorecardsPaginated scorecardsPaginated) {
            Utils.checkNotNull(scorecardsPaginated, "scorecardsPaginated");
            this.scorecardsPaginated = Optional.ofNullable(scorecardsPaginated);
            return this;
        }

        public Builder scorecardsPaginated(Optional<? extends ScorecardsPaginated> scorecardsPaginated) {
            Utils.checkNotNull(scorecardsPaginated, "scorecardsPaginated");
            this.scorecardsPaginated = scorecardsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListApplicationScorecardsResponse build() {
            return new AtsListApplicationScorecardsResponse(this.contentType, this.statusCode, this.rawResponse, this.scorecardsPaginated, this.headers);
        }
    }
}

