/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * ConnectorsMetaCategory
 * 
 * <p>The provider service category
 */
@JsonDeserialize(using = ConnectorsMetaCategory._Deserializer.class)
@JsonSerialize(using = ConnectorsMetaCategory._Serializer.class)
public class ConnectorsMetaCategory {

    public static final ConnectorsMetaCategory ATS = new ConnectorsMetaCategory("ats");
    public static final ConnectorsMetaCategory HRIS = new ConnectorsMetaCategory("hris");
    public static final ConnectorsMetaCategory HRIS_LEGACY = new ConnectorsMetaCategory("hris-legacy");
    public static final ConnectorsMetaCategory CRM = new ConnectorsMetaCategory("crm");
    public static final ConnectorsMetaCategory IAM = new ConnectorsMetaCategory("iam");
    public static final ConnectorsMetaCategory MARKETING = new ConnectorsMetaCategory("marketing");
    public static final ConnectorsMetaCategory LMS = new ConnectorsMetaCategory("lms");
    public static final ConnectorsMetaCategory STACKONE = new ConnectorsMetaCategory("stackone");
    public static final ConnectorsMetaCategory DOCUMENTS = new ConnectorsMetaCategory("documents");
    public static final ConnectorsMetaCategory TICKETING = new ConnectorsMetaCategory("ticketing");
    public static final ConnectorsMetaCategory SCREENING = new ConnectorsMetaCategory("screening");
    public static final ConnectorsMetaCategory MESSAGING = new ConnectorsMetaCategory("messaging");
    public static final ConnectorsMetaCategory ACCOUNTING = new ConnectorsMetaCategory("accounting");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ConnectorsMetaCategory> values = createValuesMap();
    private static final Map<String, ConnectorsMetaCategoryEnum> enums = createEnumsMap();

    private final String value;

    private ConnectorsMetaCategory(String value) {
        this.value = value;
    }

    /**
     * Returns a ConnectorsMetaCategory with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ConnectorsMetaCategory
     */ 
    public static ConnectorsMetaCategory of(String value) {
        synchronized (ConnectorsMetaCategory.class) {
            return values.computeIfAbsent(value, v -> new ConnectorsMetaCategory(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<ConnectorsMetaCategoryEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ConnectorsMetaCategory other = (ConnectorsMetaCategory) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ConnectorsMetaCategory [value=" + value + "]";
    }

    // return an array just like an enum
    public static ConnectorsMetaCategory[] values() {
        synchronized (ConnectorsMetaCategory.class) {
            return values.values().toArray(new ConnectorsMetaCategory[] {});
        }
    }

    private static final Map<String, ConnectorsMetaCategory> createValuesMap() {
        Map<String, ConnectorsMetaCategory> map = new LinkedHashMap<>();
        map.put("ats", ATS);
        map.put("hris", HRIS);
        map.put("hris-legacy", HRIS_LEGACY);
        map.put("crm", CRM);
        map.put("iam", IAM);
        map.put("marketing", MARKETING);
        map.put("lms", LMS);
        map.put("stackone", STACKONE);
        map.put("documents", DOCUMENTS);
        map.put("ticketing", TICKETING);
        map.put("screening", SCREENING);
        map.put("messaging", MESSAGING);
        map.put("accounting", ACCOUNTING);
        return map;
    }

    private static final Map<String, ConnectorsMetaCategoryEnum> createEnumsMap() {
        Map<String, ConnectorsMetaCategoryEnum> map = new HashMap<>();
        map.put("ats", ConnectorsMetaCategoryEnum.ATS);
        map.put("hris", ConnectorsMetaCategoryEnum.HRIS);
        map.put("hris-legacy", ConnectorsMetaCategoryEnum.HRIS_LEGACY);
        map.put("crm", ConnectorsMetaCategoryEnum.CRM);
        map.put("iam", ConnectorsMetaCategoryEnum.IAM);
        map.put("marketing", ConnectorsMetaCategoryEnum.MARKETING);
        map.put("lms", ConnectorsMetaCategoryEnum.LMS);
        map.put("stackone", ConnectorsMetaCategoryEnum.STACKONE);
        map.put("documents", ConnectorsMetaCategoryEnum.DOCUMENTS);
        map.put("ticketing", ConnectorsMetaCategoryEnum.TICKETING);
        map.put("screening", ConnectorsMetaCategoryEnum.SCREENING);
        map.put("messaging", ConnectorsMetaCategoryEnum.MESSAGING);
        map.put("accounting", ConnectorsMetaCategoryEnum.ACCOUNTING);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<ConnectorsMetaCategory> {

        protected _Serializer() {
            super(ConnectorsMetaCategory.class);
        }

        @Override
        public void serialize(ConnectorsMetaCategory value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<ConnectorsMetaCategory> {

        protected _Deserializer() {
            super(ConnectorsMetaCategory.class);
        }

        @Override
        public ConnectorsMetaCategory deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return ConnectorsMetaCategory.of(v);
        }
    }
    
    public enum ConnectorsMetaCategoryEnum {

        ATS("ats"),
        HRIS("hris"),
        HRIS_LEGACY("hris-legacy"),
        CRM("crm"),
        IAM("iam"),
        MARKETING("marketing"),
        LMS("lms"),
        STACKONE("stackone"),
        DOCUMENTS("documents"),
        TICKETING("ticketing"),
        SCREENING("screening"),
        MESSAGING("messaging"),
        ACCOUNTING("accounting"),;

        private final String value;

        private ConnectorsMetaCategoryEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

