/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class Folders {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The name associated with this folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The description of the folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * The size of this folder in bytes
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("size")
    private JsonNullable<Double> size;

    /**
     * The url of the folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("url")
    private JsonNullable<String> url;

    /**
     * The path where the folder is stored
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("path")
    private JsonNullable<String> path;

    /**
     * The user ID of owner of this folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("owner_id")
    private JsonNullable<String> ownerId;

    /**
     * Provider's unique identifier of the owner of this folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_owner_id")
    private JsonNullable<String> remoteOwnerId;

    /**
     * The parent folder ID associated with this folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parent_folder_id")
    private JsonNullable<String> parentFolderId;

    /**
     * Provider's unique identifier of the parent folder associated with this folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_parent_folder_id")
    private JsonNullable<String> remoteParentFolderId;

    /**
     * The parent drive ID associated with this folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("drive_id")
    private JsonNullable<String> driveId;

    /**
     * Provider's unique identifier of the parent drive associated with this folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_drive_id")
    private JsonNullable<String> remoteDriveId;

    /**
     * The created date of the folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The last updated date of the folder
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * Whether the folder has content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("has_content")
    private JsonNullable<? extends FoldersHasContent> hasContent;

    /**
     * Whether the folder has children
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("has_children")
    private JsonNullable<? extends FoldersHasChildren> hasChildren;

    /**
     * Whether the folder is at the root level of the drive
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("is_root")
    private JsonNullable<? extends IsRoot> isRoot;

    /**
     * List of containing parent Folder IDs in descending order
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("all_parent_folder_ids")
    private JsonNullable<? extends List<String>> allParentFolderIds;

    @JsonCreator
    public Folders(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("size") JsonNullable<Double> size,
            @JsonProperty("url") JsonNullable<String> url,
            @JsonProperty("path") JsonNullable<String> path,
            @JsonProperty("owner_id") JsonNullable<String> ownerId,
            @JsonProperty("remote_owner_id") JsonNullable<String> remoteOwnerId,
            @JsonProperty("parent_folder_id") JsonNullable<String> parentFolderId,
            @JsonProperty("remote_parent_folder_id") JsonNullable<String> remoteParentFolderId,
            @JsonProperty("drive_id") JsonNullable<String> driveId,
            @JsonProperty("remote_drive_id") JsonNullable<String> remoteDriveId,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("has_content") JsonNullable<? extends FoldersHasContent> hasContent,
            @JsonProperty("has_children") JsonNullable<? extends FoldersHasChildren> hasChildren,
            @JsonProperty("is_root") JsonNullable<? extends IsRoot> isRoot,
            @JsonProperty("all_parent_folder_ids") JsonNullable<? extends List<String>> allParentFolderIds) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(size, "size");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(ownerId, "ownerId");
        Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
        Utils.checkNotNull(parentFolderId, "parentFolderId");
        Utils.checkNotNull(remoteParentFolderId, "remoteParentFolderId");
        Utils.checkNotNull(driveId, "driveId");
        Utils.checkNotNull(remoteDriveId, "remoteDriveId");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(hasContent, "hasContent");
        Utils.checkNotNull(hasChildren, "hasChildren");
        Utils.checkNotNull(isRoot, "isRoot");
        Utils.checkNotNull(allParentFolderIds, "allParentFolderIds");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.description = description;
        this.size = size;
        this.url = url;
        this.path = path;
        this.ownerId = ownerId;
        this.remoteOwnerId = remoteOwnerId;
        this.parentFolderId = parentFolderId;
        this.remoteParentFolderId = remoteParentFolderId;
        this.driveId = driveId;
        this.remoteDriveId = remoteDriveId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.hasContent = hasContent;
        this.hasChildren = hasChildren;
        this.isRoot = isRoot;
        this.allParentFolderIds = allParentFolderIds;
    }
    
    public Folders() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The name associated with this folder
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The description of the folder
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * The size of this folder in bytes
     */
    @JsonIgnore
    public JsonNullable<Double> size() {
        return size;
    }

    /**
     * The url of the folder
     */
    @JsonIgnore
    public JsonNullable<String> url() {
        return url;
    }

    /**
     * The path where the folder is stored
     */
    @JsonIgnore
    public JsonNullable<String> path() {
        return path;
    }

    /**
     * The user ID of owner of this folder
     */
    @JsonIgnore
    public JsonNullable<String> ownerId() {
        return ownerId;
    }

    /**
     * Provider's unique identifier of the owner of this folder
     */
    @JsonIgnore
    public JsonNullable<String> remoteOwnerId() {
        return remoteOwnerId;
    }

    /**
     * The parent folder ID associated with this folder
     */
    @JsonIgnore
    public JsonNullable<String> parentFolderId() {
        return parentFolderId;
    }

    /**
     * Provider's unique identifier of the parent folder associated with this folder
     */
    @JsonIgnore
    public JsonNullable<String> remoteParentFolderId() {
        return remoteParentFolderId;
    }

    /**
     * The parent drive ID associated with this folder
     */
    @JsonIgnore
    public JsonNullable<String> driveId() {
        return driveId;
    }

    /**
     * Provider's unique identifier of the parent drive associated with this folder
     */
    @JsonIgnore
    public JsonNullable<String> remoteDriveId() {
        return remoteDriveId;
    }

    /**
     * The created date of the folder
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The last updated date of the folder
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * Whether the folder has content
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<FoldersHasContent> hasContent() {
        return (JsonNullable<FoldersHasContent>) hasContent;
    }

    /**
     * Whether the folder has children
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<FoldersHasChildren> hasChildren() {
        return (JsonNullable<FoldersHasChildren>) hasChildren;
    }

    /**
     * Whether the folder is at the root level of the drive
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IsRoot> isRoot() {
        return (JsonNullable<IsRoot>) isRoot;
    }

    /**
     * List of containing parent Folder IDs in descending order
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> allParentFolderIds() {
        return (JsonNullable<List<String>>) allParentFolderIds;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public Folders withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Folders withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Folders withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Folders withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The name associated with this folder
     */
    public Folders withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name associated with this folder
     */
    public Folders withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The description of the folder
     */
    public Folders withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * The description of the folder
     */
    public Folders withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The size of this folder in bytes
     */
    public Folders withSize(double size) {
        Utils.checkNotNull(size, "size");
        this.size = JsonNullable.of(size);
        return this;
    }

    /**
     * The size of this folder in bytes
     */
    public Folders withSize(JsonNullable<Double> size) {
        Utils.checkNotNull(size, "size");
        this.size = size;
        return this;
    }

    /**
     * The url of the folder
     */
    public Folders withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of(url);
        return this;
    }

    /**
     * The url of the folder
     */
    public Folders withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    /**
     * The path where the folder is stored
     */
    public Folders withPath(String path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of(path);
        return this;
    }

    /**
     * The path where the folder is stored
     */
    public Folders withPath(JsonNullable<String> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    /**
     * The user ID of owner of this folder
     */
    public Folders withOwnerId(String ownerId) {
        Utils.checkNotNull(ownerId, "ownerId");
        this.ownerId = JsonNullable.of(ownerId);
        return this;
    }

    /**
     * The user ID of owner of this folder
     */
    public Folders withOwnerId(JsonNullable<String> ownerId) {
        Utils.checkNotNull(ownerId, "ownerId");
        this.ownerId = ownerId;
        return this;
    }

    /**
     * Provider's unique identifier of the owner of this folder
     */
    public Folders withRemoteOwnerId(String remoteOwnerId) {
        Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
        this.remoteOwnerId = JsonNullable.of(remoteOwnerId);
        return this;
    }

    /**
     * Provider's unique identifier of the owner of this folder
     */
    public Folders withRemoteOwnerId(JsonNullable<String> remoteOwnerId) {
        Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
        this.remoteOwnerId = remoteOwnerId;
        return this;
    }

    /**
     * The parent folder ID associated with this folder
     */
    public Folders withParentFolderId(String parentFolderId) {
        Utils.checkNotNull(parentFolderId, "parentFolderId");
        this.parentFolderId = JsonNullable.of(parentFolderId);
        return this;
    }

    /**
     * The parent folder ID associated with this folder
     */
    public Folders withParentFolderId(JsonNullable<String> parentFolderId) {
        Utils.checkNotNull(parentFolderId, "parentFolderId");
        this.parentFolderId = parentFolderId;
        return this;
    }

    /**
     * Provider's unique identifier of the parent folder associated with this folder
     */
    public Folders withRemoteParentFolderId(String remoteParentFolderId) {
        Utils.checkNotNull(remoteParentFolderId, "remoteParentFolderId");
        this.remoteParentFolderId = JsonNullable.of(remoteParentFolderId);
        return this;
    }

    /**
     * Provider's unique identifier of the parent folder associated with this folder
     */
    public Folders withRemoteParentFolderId(JsonNullable<String> remoteParentFolderId) {
        Utils.checkNotNull(remoteParentFolderId, "remoteParentFolderId");
        this.remoteParentFolderId = remoteParentFolderId;
        return this;
    }

    /**
     * The parent drive ID associated with this folder
     */
    public Folders withDriveId(String driveId) {
        Utils.checkNotNull(driveId, "driveId");
        this.driveId = JsonNullable.of(driveId);
        return this;
    }

    /**
     * The parent drive ID associated with this folder
     */
    public Folders withDriveId(JsonNullable<String> driveId) {
        Utils.checkNotNull(driveId, "driveId");
        this.driveId = driveId;
        return this;
    }

    /**
     * Provider's unique identifier of the parent drive associated with this folder
     */
    public Folders withRemoteDriveId(String remoteDriveId) {
        Utils.checkNotNull(remoteDriveId, "remoteDriveId");
        this.remoteDriveId = JsonNullable.of(remoteDriveId);
        return this;
    }

    /**
     * Provider's unique identifier of the parent drive associated with this folder
     */
    public Folders withRemoteDriveId(JsonNullable<String> remoteDriveId) {
        Utils.checkNotNull(remoteDriveId, "remoteDriveId");
        this.remoteDriveId = remoteDriveId;
        return this;
    }

    /**
     * The created date of the folder
     */
    public Folders withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The created date of the folder
     */
    public Folders withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The last updated date of the folder
     */
    public Folders withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The last updated date of the folder
     */
    public Folders withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * Whether the folder has content
     */
    public Folders withHasContent(FoldersHasContent hasContent) {
        Utils.checkNotNull(hasContent, "hasContent");
        this.hasContent = JsonNullable.of(hasContent);
        return this;
    }

    /**
     * Whether the folder has content
     */
    public Folders withHasContent(JsonNullable<? extends FoldersHasContent> hasContent) {
        Utils.checkNotNull(hasContent, "hasContent");
        this.hasContent = hasContent;
        return this;
    }

    /**
     * Whether the folder has children
     */
    public Folders withHasChildren(FoldersHasChildren hasChildren) {
        Utils.checkNotNull(hasChildren, "hasChildren");
        this.hasChildren = JsonNullable.of(hasChildren);
        return this;
    }

    /**
     * Whether the folder has children
     */
    public Folders withHasChildren(JsonNullable<? extends FoldersHasChildren> hasChildren) {
        Utils.checkNotNull(hasChildren, "hasChildren");
        this.hasChildren = hasChildren;
        return this;
    }

    /**
     * Whether the folder is at the root level of the drive
     */
    public Folders withIsRoot(IsRoot isRoot) {
        Utils.checkNotNull(isRoot, "isRoot");
        this.isRoot = JsonNullable.of(isRoot);
        return this;
    }

    /**
     * Whether the folder is at the root level of the drive
     */
    public Folders withIsRoot(JsonNullable<? extends IsRoot> isRoot) {
        Utils.checkNotNull(isRoot, "isRoot");
        this.isRoot = isRoot;
        return this;
    }

    /**
     * List of containing parent Folder IDs in descending order
     */
    public Folders withAllParentFolderIds(List<String> allParentFolderIds) {
        Utils.checkNotNull(allParentFolderIds, "allParentFolderIds");
        this.allParentFolderIds = JsonNullable.of(allParentFolderIds);
        return this;
    }

    /**
     * List of containing parent Folder IDs in descending order
     */
    public Folders withAllParentFolderIds(JsonNullable<? extends List<String>> allParentFolderIds) {
        Utils.checkNotNull(allParentFolderIds, "allParentFolderIds");
        this.allParentFolderIds = allParentFolderIds;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Folders other = (Folders) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.size, other.size) &&
            Utils.enhancedDeepEquals(this.url, other.url) &&
            Utils.enhancedDeepEquals(this.path, other.path) &&
            Utils.enhancedDeepEquals(this.ownerId, other.ownerId) &&
            Utils.enhancedDeepEquals(this.remoteOwnerId, other.remoteOwnerId) &&
            Utils.enhancedDeepEquals(this.parentFolderId, other.parentFolderId) &&
            Utils.enhancedDeepEquals(this.remoteParentFolderId, other.remoteParentFolderId) &&
            Utils.enhancedDeepEquals(this.driveId, other.driveId) &&
            Utils.enhancedDeepEquals(this.remoteDriveId, other.remoteDriveId) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.hasContent, other.hasContent) &&
            Utils.enhancedDeepEquals(this.hasChildren, other.hasChildren) &&
            Utils.enhancedDeepEquals(this.isRoot, other.isRoot) &&
            Utils.enhancedDeepEquals(this.allParentFolderIds, other.allParentFolderIds);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, name,
            description, size, url,
            path, ownerId, remoteOwnerId,
            parentFolderId, remoteParentFolderId, driveId,
            remoteDriveId, createdAt, updatedAt,
            hasContent, hasChildren, isRoot,
            allParentFolderIds);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Folders.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "description", description,
                "size", size,
                "url", url,
                "path", path,
                "ownerId", ownerId,
                "remoteOwnerId", remoteOwnerId,
                "parentFolderId", parentFolderId,
                "remoteParentFolderId", remoteParentFolderId,
                "driveId", driveId,
                "remoteDriveId", remoteDriveId,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "hasContent", hasContent,
                "hasChildren", hasChildren,
                "isRoot", isRoot,
                "allParentFolderIds", allParentFolderIds);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<Double> size = JsonNullable.undefined();

        private JsonNullable<String> url = JsonNullable.undefined();

        private JsonNullable<String> path = JsonNullable.undefined();

        private JsonNullable<String> ownerId = JsonNullable.undefined();

        private JsonNullable<String> remoteOwnerId = JsonNullable.undefined();

        private JsonNullable<String> parentFolderId = JsonNullable.undefined();

        private JsonNullable<String> remoteParentFolderId = JsonNullable.undefined();

        private JsonNullable<String> driveId = JsonNullable.undefined();

        private JsonNullable<String> remoteDriveId = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private JsonNullable<? extends FoldersHasContent> hasContent = JsonNullable.undefined();

        private JsonNullable<? extends FoldersHasChildren> hasChildren = JsonNullable.undefined();

        private JsonNullable<? extends IsRoot> isRoot = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> allParentFolderIds = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The name associated with this folder
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name associated with this folder
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * The description of the folder
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * The description of the folder
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * The size of this folder in bytes
         */
        public Builder size(double size) {
            Utils.checkNotNull(size, "size");
            this.size = JsonNullable.of(size);
            return this;
        }

        /**
         * The size of this folder in bytes
         */
        public Builder size(JsonNullable<Double> size) {
            Utils.checkNotNull(size, "size");
            this.size = size;
            return this;
        }


        /**
         * The url of the folder
         */
        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of(url);
            return this;
        }

        /**
         * The url of the folder
         */
        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }


        /**
         * The path where the folder is stored
         */
        public Builder path(String path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of(path);
            return this;
        }

        /**
         * The path where the folder is stored
         */
        public Builder path(JsonNullable<String> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }


        /**
         * The user ID of owner of this folder
         */
        public Builder ownerId(String ownerId) {
            Utils.checkNotNull(ownerId, "ownerId");
            this.ownerId = JsonNullable.of(ownerId);
            return this;
        }

        /**
         * The user ID of owner of this folder
         */
        public Builder ownerId(JsonNullable<String> ownerId) {
            Utils.checkNotNull(ownerId, "ownerId");
            this.ownerId = ownerId;
            return this;
        }


        /**
         * Provider's unique identifier of the owner of this folder
         */
        public Builder remoteOwnerId(String remoteOwnerId) {
            Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
            this.remoteOwnerId = JsonNullable.of(remoteOwnerId);
            return this;
        }

        /**
         * Provider's unique identifier of the owner of this folder
         */
        public Builder remoteOwnerId(JsonNullable<String> remoteOwnerId) {
            Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
            this.remoteOwnerId = remoteOwnerId;
            return this;
        }


        /**
         * The parent folder ID associated with this folder
         */
        public Builder parentFolderId(String parentFolderId) {
            Utils.checkNotNull(parentFolderId, "parentFolderId");
            this.parentFolderId = JsonNullable.of(parentFolderId);
            return this;
        }

        /**
         * The parent folder ID associated with this folder
         */
        public Builder parentFolderId(JsonNullable<String> parentFolderId) {
            Utils.checkNotNull(parentFolderId, "parentFolderId");
            this.parentFolderId = parentFolderId;
            return this;
        }


        /**
         * Provider's unique identifier of the parent folder associated with this folder
         */
        public Builder remoteParentFolderId(String remoteParentFolderId) {
            Utils.checkNotNull(remoteParentFolderId, "remoteParentFolderId");
            this.remoteParentFolderId = JsonNullable.of(remoteParentFolderId);
            return this;
        }

        /**
         * Provider's unique identifier of the parent folder associated with this folder
         */
        public Builder remoteParentFolderId(JsonNullable<String> remoteParentFolderId) {
            Utils.checkNotNull(remoteParentFolderId, "remoteParentFolderId");
            this.remoteParentFolderId = remoteParentFolderId;
            return this;
        }


        /**
         * The parent drive ID associated with this folder
         */
        public Builder driveId(String driveId) {
            Utils.checkNotNull(driveId, "driveId");
            this.driveId = JsonNullable.of(driveId);
            return this;
        }

        /**
         * The parent drive ID associated with this folder
         */
        public Builder driveId(JsonNullable<String> driveId) {
            Utils.checkNotNull(driveId, "driveId");
            this.driveId = driveId;
            return this;
        }


        /**
         * Provider's unique identifier of the parent drive associated with this folder
         */
        public Builder remoteDriveId(String remoteDriveId) {
            Utils.checkNotNull(remoteDriveId, "remoteDriveId");
            this.remoteDriveId = JsonNullable.of(remoteDriveId);
            return this;
        }

        /**
         * Provider's unique identifier of the parent drive associated with this folder
         */
        public Builder remoteDriveId(JsonNullable<String> remoteDriveId) {
            Utils.checkNotNull(remoteDriveId, "remoteDriveId");
            this.remoteDriveId = remoteDriveId;
            return this;
        }


        /**
         * The created date of the folder
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The created date of the folder
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The last updated date of the folder
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The last updated date of the folder
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }


        /**
         * Whether the folder has content
         */
        public Builder hasContent(FoldersHasContent hasContent) {
            Utils.checkNotNull(hasContent, "hasContent");
            this.hasContent = JsonNullable.of(hasContent);
            return this;
        }

        /**
         * Whether the folder has content
         */
        public Builder hasContent(JsonNullable<? extends FoldersHasContent> hasContent) {
            Utils.checkNotNull(hasContent, "hasContent");
            this.hasContent = hasContent;
            return this;
        }


        /**
         * Whether the folder has children
         */
        public Builder hasChildren(FoldersHasChildren hasChildren) {
            Utils.checkNotNull(hasChildren, "hasChildren");
            this.hasChildren = JsonNullable.of(hasChildren);
            return this;
        }

        /**
         * Whether the folder has children
         */
        public Builder hasChildren(JsonNullable<? extends FoldersHasChildren> hasChildren) {
            Utils.checkNotNull(hasChildren, "hasChildren");
            this.hasChildren = hasChildren;
            return this;
        }


        /**
         * Whether the folder is at the root level of the drive
         */
        public Builder isRoot(IsRoot isRoot) {
            Utils.checkNotNull(isRoot, "isRoot");
            this.isRoot = JsonNullable.of(isRoot);
            return this;
        }

        /**
         * Whether the folder is at the root level of the drive
         */
        public Builder isRoot(JsonNullable<? extends IsRoot> isRoot) {
            Utils.checkNotNull(isRoot, "isRoot");
            this.isRoot = isRoot;
            return this;
        }


        /**
         * List of containing parent Folder IDs in descending order
         */
        public Builder allParentFolderIds(List<String> allParentFolderIds) {
            Utils.checkNotNull(allParentFolderIds, "allParentFolderIds");
            this.allParentFolderIds = JsonNullable.of(allParentFolderIds);
            return this;
        }

        /**
         * List of containing parent Folder IDs in descending order
         */
        public Builder allParentFolderIds(JsonNullable<? extends List<String>> allParentFolderIds) {
            Utils.checkNotNull(allParentFolderIds, "allParentFolderIds");
            this.allParentFolderIds = allParentFolderIds;
            return this;
        }

        public Folders build() {

            return new Folders(
                id, remoteId, name,
                description, size, url,
                path, ownerId, remoteOwnerId,
                parentFolderId, remoteParentFolderId, driveId,
                remoteDriveId, createdAt, updatedAt,
                hasContent, hasChildren, isRoot,
                allParentFolderIds);
        }

    }
}
