/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * TaskResultDataValue
 * 
 * <p>The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
 */
@JsonDeserialize(using = TaskResultDataValue._Deserializer.class)
@JsonSerialize(using = TaskResultDataValue._Serializer.class)
public class TaskResultDataValue {

    public static final TaskResultDataValue OPEN = new TaskResultDataValue("open");
    public static final TaskResultDataValue IN_PROGRESS = new TaskResultDataValue("in_progress");
    public static final TaskResultDataValue BLOCKED = new TaskResultDataValue("blocked");
    public static final TaskResultDataValue COMPLETED = new TaskResultDataValue("completed");
    public static final TaskResultDataValue CANCELLED = new TaskResultDataValue("cancelled");
    public static final TaskResultDataValue UNMAPPED_VALUE = new TaskResultDataValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TaskResultDataValue> values = createValuesMap();
    private static final Map<String, TaskResultDataValueEnum> enums = createEnumsMap();

    private final String value;

    private TaskResultDataValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TaskResultDataValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TaskResultDataValue
     */ 
    public static TaskResultDataValue of(String value) {
        synchronized (TaskResultDataValue.class) {
            return values.computeIfAbsent(value, v -> new TaskResultDataValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<TaskResultDataValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TaskResultDataValue other = (TaskResultDataValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TaskResultDataValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TaskResultDataValue[] values() {
        synchronized (TaskResultDataValue.class) {
            return values.values().toArray(new TaskResultDataValue[] {});
        }
    }

    private static final Map<String, TaskResultDataValue> createValuesMap() {
        Map<String, TaskResultDataValue> map = new LinkedHashMap<>();
        map.put("open", OPEN);
        map.put("in_progress", IN_PROGRESS);
        map.put("blocked", BLOCKED);
        map.put("completed", COMPLETED);
        map.put("cancelled", CANCELLED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TaskResultDataValueEnum> createEnumsMap() {
        Map<String, TaskResultDataValueEnum> map = new HashMap<>();
        map.put("open", TaskResultDataValueEnum.OPEN);
        map.put("in_progress", TaskResultDataValueEnum.IN_PROGRESS);
        map.put("blocked", TaskResultDataValueEnum.BLOCKED);
        map.put("completed", TaskResultDataValueEnum.COMPLETED);
        map.put("cancelled", TaskResultDataValueEnum.CANCELLED);
        map.put("unmapped_value", TaskResultDataValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<TaskResultDataValue> {

        protected _Serializer() {
            super(TaskResultDataValue.class);
        }

        @Override
        public void serialize(TaskResultDataValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<TaskResultDataValue> {

        protected _Deserializer() {
            super(TaskResultDataValue.class);
        }

        @Override
        public TaskResultDataValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return TaskResultDataValue.of(v);
        }
    }
    
    public enum TaskResultDataValueEnum {

        OPEN("open"),
        IN_PROGRESS("in_progress"),
        BLOCKED("blocked"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TaskResultDataValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

