/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class ApplicationAttachmentValue {
    public static final ApplicationAttachmentValue TEXT = new ApplicationAttachmentValue("text");
    public static final ApplicationAttachmentValue UNMAPPED_VALUE = new ApplicationAttachmentValue("unmapped_value");
    private static final Map<String, ApplicationAttachmentValue> values = ApplicationAttachmentValue.createValuesMap();
    private static final Map<String, ApplicationAttachmentValueEnum> enums = ApplicationAttachmentValue.createEnumsMap();
    private final String value;

    private ApplicationAttachmentValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationAttachmentValue of(String value) {
        Class<ApplicationAttachmentValue> clazz = ApplicationAttachmentValue.class;
        synchronized (ApplicationAttachmentValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ApplicationAttachmentValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<ApplicationAttachmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationAttachmentValue other = (ApplicationAttachmentValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ApplicationAttachmentValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationAttachmentValue[] values() {
        Class<ApplicationAttachmentValue> clazz = ApplicationAttachmentValue.class;
        synchronized (ApplicationAttachmentValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ApplicationAttachmentValue[0]);
        }
    }

    private static final Map<String, ApplicationAttachmentValue> createValuesMap() {
        LinkedHashMap<String, ApplicationAttachmentValue> map = new LinkedHashMap<String, ApplicationAttachmentValue>();
        map.put("text", TEXT);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ApplicationAttachmentValueEnum> createEnumsMap() {
        HashMap<String, ApplicationAttachmentValueEnum> map = new HashMap<String, ApplicationAttachmentValueEnum>();
        map.put("text", ApplicationAttachmentValueEnum.TEXT);
        map.put("unmapped_value", ApplicationAttachmentValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ApplicationAttachmentValueEnum {
        TEXT("text"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ApplicationAttachmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<ApplicationAttachmentValue> {
        protected _Deserializer() {
            super(ApplicationAttachmentValue.class);
        }

        public ApplicationAttachmentValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return ApplicationAttachmentValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<ApplicationAttachmentValue> {
        protected _Serializer() {
            super(ApplicationAttachmentValue.class);
        }

        public void serialize(ApplicationAttachmentValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

