/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingAccountsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AccountingListCompanyAccountsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AccountingAccountsPaginated> accountingAccountsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AccountingListCompanyAccountsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AccountingAccountsPaginated> accountingAccountsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountingAccountsPaginated, "accountingAccountsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountingAccountsPaginated = accountingAccountsPaginated;
        this.headers = headers;
    }

    public AccountingListCompanyAccountsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountingAccountsPaginated> accountingAccountsPaginated() {
        return this.accountingAccountsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingListCompanyAccountsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AccountingListCompanyAccountsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AccountingListCompanyAccountsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AccountingListCompanyAccountsResponse withAccountingAccountsPaginated(AccountingAccountsPaginated accountingAccountsPaginated) {
        Utils.checkNotNull(accountingAccountsPaginated, "accountingAccountsPaginated");
        this.accountingAccountsPaginated = Optional.ofNullable(accountingAccountsPaginated);
        return this;
    }

    public AccountingListCompanyAccountsResponse withAccountingAccountsPaginated(Optional<? extends AccountingAccountsPaginated> accountingAccountsPaginated) {
        Utils.checkNotNull(accountingAccountsPaginated, "accountingAccountsPaginated");
        this.accountingAccountsPaginated = accountingAccountsPaginated;
        return this;
    }

    public AccountingListCompanyAccountsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingListCompanyAccountsResponse other = (AccountingListCompanyAccountsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.accountingAccountsPaginated, other.accountingAccountsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.accountingAccountsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AccountingListCompanyAccountsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountingAccountsPaginated", this.accountingAccountsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AccountingAccountsPaginated> accountingAccountsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountingAccountsPaginated(AccountingAccountsPaginated accountingAccountsPaginated) {
            Utils.checkNotNull(accountingAccountsPaginated, "accountingAccountsPaginated");
            this.accountingAccountsPaginated = Optional.ofNullable(accountingAccountsPaginated);
            return this;
        }

        public Builder accountingAccountsPaginated(Optional<? extends AccountingAccountsPaginated> accountingAccountsPaginated) {
            Utils.checkNotNull(accountingAccountsPaginated, "accountingAccountsPaginated");
            this.accountingAccountsPaginated = accountingAccountsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AccountingListCompanyAccountsResponse build() {
            return new AccountingListCompanyAccountsResponse(this.contentType, this.statusCode, this.rawResponse, this.accountingAccountsPaginated, this.headers);
        }
    }
}

