/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class MessagingCreateConversationRequestDto {
    /**
     * List of participant user IDs in the conversation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("participants")
    private JsonNullable<? extends List<String>> participants;

    /**
     * Name or title of the conversation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * Whether the conversation is private
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("private")
    private JsonNullable<? extends MessagingCreateConversationRequestDtoPrivate> private_;

    @JsonCreator
    public MessagingCreateConversationRequestDto(
            @JsonProperty("participants") JsonNullable<? extends List<String>> participants,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("private") JsonNullable<? extends MessagingCreateConversationRequestDtoPrivate> private_) {
        Utils.checkNotNull(participants, "participants");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(private_, "private_");
        this.participants = participants;
        this.name = name;
        this.private_ = private_;
    }
    
    public MessagingCreateConversationRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * List of participant user IDs in the conversation
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> participants() {
        return (JsonNullable<List<String>>) participants;
    }

    /**
     * Name or title of the conversation
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * Whether the conversation is private
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<MessagingCreateConversationRequestDtoPrivate> private_() {
        return (JsonNullable<MessagingCreateConversationRequestDtoPrivate>) private_;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * List of participant user IDs in the conversation
     */
    public MessagingCreateConversationRequestDto withParticipants(List<String> participants) {
        Utils.checkNotNull(participants, "participants");
        this.participants = JsonNullable.of(participants);
        return this;
    }

    /**
     * List of participant user IDs in the conversation
     */
    public MessagingCreateConversationRequestDto withParticipants(JsonNullable<? extends List<String>> participants) {
        Utils.checkNotNull(participants, "participants");
        this.participants = participants;
        return this;
    }

    /**
     * Name or title of the conversation
     */
    public MessagingCreateConversationRequestDto withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * Name or title of the conversation
     */
    public MessagingCreateConversationRequestDto withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Whether the conversation is private
     */
    public MessagingCreateConversationRequestDto withPrivate(MessagingCreateConversationRequestDtoPrivate private_) {
        Utils.checkNotNull(private_, "private_");
        this.private_ = JsonNullable.of(private_);
        return this;
    }

    /**
     * Whether the conversation is private
     */
    public MessagingCreateConversationRequestDto withPrivate(JsonNullable<? extends MessagingCreateConversationRequestDtoPrivate> private_) {
        Utils.checkNotNull(private_, "private_");
        this.private_ = private_;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingCreateConversationRequestDto other = (MessagingCreateConversationRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.participants, other.participants) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.private_, other.private_);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            participants, name, private_);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingCreateConversationRequestDto.class,
                "participants", participants,
                "name", name,
                "private_", private_);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends List<String>> participants = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<? extends MessagingCreateConversationRequestDtoPrivate> private_ = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * List of participant user IDs in the conversation
         */
        public Builder participants(List<String> participants) {
            Utils.checkNotNull(participants, "participants");
            this.participants = JsonNullable.of(participants);
            return this;
        }

        /**
         * List of participant user IDs in the conversation
         */
        public Builder participants(JsonNullable<? extends List<String>> participants) {
            Utils.checkNotNull(participants, "participants");
            this.participants = participants;
            return this;
        }


        /**
         * Name or title of the conversation
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * Name or title of the conversation
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * Whether the conversation is private
         */
        public Builder private_(MessagingCreateConversationRequestDtoPrivate private_) {
            Utils.checkNotNull(private_, "private_");
            this.private_ = JsonNullable.of(private_);
            return this;
        }

        /**
         * Whether the conversation is private
         */
        public Builder private_(JsonNullable<? extends MessagingCreateConversationRequestDtoPrivate> private_) {
            Utils.checkNotNull(private_, "private_");
            this.private_ = private_;
            return this;
        }

        public MessagingCreateConversationRequestDto build() {

            return new MessagingCreateConversationRequestDto(
                participants, name, private_);
        }

    }
}
