/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * TicketingTicketResultOrganization
 * 
 * <p>Organization associated with the ticket
 */
public class TicketingTicketResultOrganization {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The domain of the organization
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("domain")
    private JsonNullable<String> domain;

    /**
     * The name of the organization
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    @JsonCreator
    public TicketingTicketResultOrganization(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("domain") JsonNullable<String> domain,
            @JsonProperty("name") JsonNullable<String> name) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(domain, "domain");
        Utils.checkNotNull(name, "name");
        this.id = id;
        this.remoteId = remoteId;
        this.domain = domain;
        this.name = name;
    }
    
    public TicketingTicketResultOrganization() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The domain of the organization
     */
    @JsonIgnore
    public JsonNullable<String> domain() {
        return domain;
    }

    /**
     * The name of the organization
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public TicketingTicketResultOrganization withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public TicketingTicketResultOrganization withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TicketingTicketResultOrganization withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TicketingTicketResultOrganization withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The domain of the organization
     */
    public TicketingTicketResultOrganization withDomain(String domain) {
        Utils.checkNotNull(domain, "domain");
        this.domain = JsonNullable.of(domain);
        return this;
    }

    /**
     * The domain of the organization
     */
    public TicketingTicketResultOrganization withDomain(JsonNullable<String> domain) {
        Utils.checkNotNull(domain, "domain");
        this.domain = domain;
        return this;
    }

    /**
     * The name of the organization
     */
    public TicketingTicketResultOrganization withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name of the organization
     */
    public TicketingTicketResultOrganization withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketingTicketResultOrganization other = (TicketingTicketResultOrganization) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.domain, other.domain) &&
            Utils.enhancedDeepEquals(this.name, other.name);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, domain,
            name);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketingTicketResultOrganization.class,
                "id", id,
                "remoteId", remoteId,
                "domain", domain,
                "name", name);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> domain = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The domain of the organization
         */
        public Builder domain(String domain) {
            Utils.checkNotNull(domain, "domain");
            this.domain = JsonNullable.of(domain);
            return this;
        }

        /**
         * The domain of the organization
         */
        public Builder domain(JsonNullable<String> domain) {
            Utils.checkNotNull(domain, "domain");
            this.domain = domain;
            return this;
        }


        /**
         * The name of the organization
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name of the organization
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public TicketingTicketResultOrganization build() {

            return new TicketingTicketResultOrganization(
                id, remoteId, domain,
                name);
        }

    }
}
