/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.JsonRpcMessageDto;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteSecurity;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetSecurity;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostSecurity;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpDeleteRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpDeleteResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpGetRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpGetResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpPostRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpPostResponse;
import com.stackone.stackone_client_java.operations.StackoneMcpDelete;
import com.stackone.stackone_client_java.operations.StackoneMcpGet;
import com.stackone.stackone_client_java.operations.StackoneMcpPost;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * Model Context Protocol endpoint.
 */
public class AsyncMcp {
    private final SDKConfiguration sdkConfiguration;
    private final Mcp syncSDK;

    AsyncMcp(Mcp syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Mcp sync() {
        return syncSDK;
    }


    /**
     * Open MCP SSE stream
     * 
     * <p>Open a dedicated Server-Sent Events stream for MCP notifications
     * 
     * @return The async call builder
     */
    public StackoneMcpGetRequestBuilder mcpGet() {
        return new StackoneMcpGetRequestBuilder(sdkConfiguration);
    }

    /**
     * Open MCP SSE stream
     * 
     * <p>Open a dedicated Server-Sent Events stream for MCP notifications
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param mcpSessionId Session id
     * @return CompletableFuture&lt;StackoneMcpGetResponse&gt; - The async response
     */
    public CompletableFuture<StackoneMcpGetResponse> mcpGet(
            StackoneMcpGetSecurity security, String xAccountId,
            String mcpSessionId) {
        return mcpGet(
                security, xAccountId, mcpSessionId,
                Optional.empty());
    }

    /**
     * Open MCP SSE stream
     * 
     * <p>Open a dedicated Server-Sent Events stream for MCP notifications
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param mcpSessionId Session id
     * @param options additional options
     * @return CompletableFuture&lt;StackoneMcpGetResponse&gt; - The async response
     */
    public CompletableFuture<StackoneMcpGetResponse> mcpGet(
            StackoneMcpGetSecurity security, String xAccountId,
            String mcpSessionId, Optional<Options> options) {
        StackoneMcpGetRequest request =
            StackoneMcpGetRequest
                .builder()
                .xAccountId(xAccountId)
                .mcpSessionId(mcpSessionId)
                .build();
        AsyncRequestOperation<StackoneMcpGetRequest, StackoneMcpGetResponse> operation
              = new StackoneMcpGet.Async(
                                    sdkConfiguration, security, options,
                                    sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Send MCP JSON-RPC message
     * 
     * <p>Send JSON-RPC request to the MCP server over HTTP streaming transport
     * 
     * @return The async call builder
     */
    public StackoneMcpPostRequestBuilder mcpPost() {
        return new StackoneMcpPostRequestBuilder(sdkConfiguration);
    }

    /**
     * Send MCP JSON-RPC message
     * 
     * <p>Send JSON-RPC request to the MCP server over HTTP streaming transport
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param jsonRpcMessageDto 
     * @return CompletableFuture&lt;StackoneMcpPostResponse&gt; - The async response
     */
    public CompletableFuture<StackoneMcpPostResponse> mcpPost(
            StackoneMcpPostSecurity security, String xAccountId,
            JsonRpcMessageDto jsonRpcMessageDto) {
        return mcpPost(
                security, xAccountId, Optional.empty(),
                jsonRpcMessageDto, Optional.empty());
    }

    /**
     * Send MCP JSON-RPC message
     * 
     * <p>Send JSON-RPC request to the MCP server over HTTP streaming transport
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param mcpSessionId Session id; omit for initialize, include for subsequent calls
     * @param jsonRpcMessageDto 
     * @param options additional options
     * @return CompletableFuture&lt;StackoneMcpPostResponse&gt; - The async response
     */
    public CompletableFuture<StackoneMcpPostResponse> mcpPost(
            StackoneMcpPostSecurity security, String xAccountId,
            Optional<String> mcpSessionId, JsonRpcMessageDto jsonRpcMessageDto,
            Optional<Options> options) {
        StackoneMcpPostRequest request =
            StackoneMcpPostRequest
                .builder()
                .xAccountId(xAccountId)
                .mcpSessionId(mcpSessionId)
                .jsonRpcMessageDto(jsonRpcMessageDto)
                .build();
        AsyncRequestOperation<StackoneMcpPostRequest, StackoneMcpPostResponse> operation
              = new StackoneMcpPost.Async(
                                    sdkConfiguration, security, options,
                                    sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Delete MCP session
     * 
     * <p>Close an existing MCP session for the provided session id
     * 
     * @return The async call builder
     */
    public StackoneMcpDeleteRequestBuilder mcpDelete() {
        return new StackoneMcpDeleteRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete MCP session
     * 
     * <p>Close an existing MCP session for the provided session id
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param mcpSessionId Session id
     * @return CompletableFuture&lt;StackoneMcpDeleteResponse&gt; - The async response
     */
    public CompletableFuture<StackoneMcpDeleteResponse> mcpDelete(
            StackoneMcpDeleteSecurity security, String xAccountId,
            String mcpSessionId) {
        return mcpDelete(
                security, xAccountId, mcpSessionId,
                Optional.empty());
    }

    /**
     * Delete MCP session
     * 
     * <p>Close an existing MCP session for the provided session id
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param mcpSessionId Session id
     * @param options additional options
     * @return CompletableFuture&lt;StackoneMcpDeleteResponse&gt; - The async response
     */
    public CompletableFuture<StackoneMcpDeleteResponse> mcpDelete(
            StackoneMcpDeleteSecurity security, String xAccountId,
            String mcpSessionId, Optional<Options> options) {
        StackoneMcpDeleteRequest request =
            StackoneMcpDeleteRequest
                .builder()
                .xAccountId(xAccountId)
                .mcpSessionId(mcpSessionId)
                .build();
        AsyncRequestOperation<StackoneMcpDeleteRequest, StackoneMcpDeleteResponse> operation
              = new StackoneMcpDelete.Async(
                                    sdkConfiguration, security, options,
                                    sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
