/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class ActionMetaItem {
    /**
     * The action ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * The action name
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The action description
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * The schema type for the action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("schema_type")
    private JsonNullable<String> schemaType;

    /**
     * The authentication methods supported by this action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("authentication")
    private JsonNullable<? extends List<AuthenticationMetaItem>> authentication;

    /**
     * The operation details for the action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("operation_details")
    private JsonNullable<? extends Map<String, Object>> operationDetails;

    @JsonCreator
    public ActionMetaItem(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("schema_type") JsonNullable<String> schemaType,
            @JsonProperty("authentication") JsonNullable<? extends List<AuthenticationMetaItem>> authentication,
            @JsonProperty("operation_details") JsonNullable<? extends Map<String, Object>> operationDetails) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(schemaType, "schemaType");
        Utils.checkNotNull(authentication, "authentication");
        Utils.checkNotNull(operationDetails, "operationDetails");
        this.id = id;
        this.name = name;
        this.description = description;
        this.schemaType = schemaType;
        this.authentication = authentication;
        this.operationDetails = operationDetails;
    }
    
    public ActionMetaItem() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The action ID
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * The action name
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The action description
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * The schema type for the action
     */
    @JsonIgnore
    public JsonNullable<String> schemaType() {
        return schemaType;
    }

    /**
     * The authentication methods supported by this action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<AuthenticationMetaItem>> authentication() {
        return (JsonNullable<List<AuthenticationMetaItem>>) authentication;
    }

    /**
     * The operation details for the action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> operationDetails() {
        return (JsonNullable<Map<String, Object>>) operationDetails;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The action ID
     */
    public ActionMetaItem withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The action ID
     */
    public ActionMetaItem withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The action name
     */
    public ActionMetaItem withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The action name
     */
    public ActionMetaItem withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The action description
     */
    public ActionMetaItem withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * The action description
     */
    public ActionMetaItem withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The schema type for the action
     */
    public ActionMetaItem withSchemaType(String schemaType) {
        Utils.checkNotNull(schemaType, "schemaType");
        this.schemaType = JsonNullable.of(schemaType);
        return this;
    }

    /**
     * The schema type for the action
     */
    public ActionMetaItem withSchemaType(JsonNullable<String> schemaType) {
        Utils.checkNotNull(schemaType, "schemaType");
        this.schemaType = schemaType;
        return this;
    }

    /**
     * The authentication methods supported by this action
     */
    public ActionMetaItem withAuthentication(List<AuthenticationMetaItem> authentication) {
        Utils.checkNotNull(authentication, "authentication");
        this.authentication = JsonNullable.of(authentication);
        return this;
    }

    /**
     * The authentication methods supported by this action
     */
    public ActionMetaItem withAuthentication(JsonNullable<? extends List<AuthenticationMetaItem>> authentication) {
        Utils.checkNotNull(authentication, "authentication");
        this.authentication = authentication;
        return this;
    }

    /**
     * The operation details for the action
     */
    public ActionMetaItem withOperationDetails(Map<String, Object> operationDetails) {
        Utils.checkNotNull(operationDetails, "operationDetails");
        this.operationDetails = JsonNullable.of(operationDetails);
        return this;
    }

    /**
     * The operation details for the action
     */
    public ActionMetaItem withOperationDetails(JsonNullable<? extends Map<String, Object>> operationDetails) {
        Utils.checkNotNull(operationDetails, "operationDetails");
        this.operationDetails = operationDetails;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionMetaItem other = (ActionMetaItem) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.schemaType, other.schemaType) &&
            Utils.enhancedDeepEquals(this.authentication, other.authentication) &&
            Utils.enhancedDeepEquals(this.operationDetails, other.operationDetails);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, name, description,
            schemaType, authentication, operationDetails);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ActionMetaItem.class,
                "id", id,
                "name", name,
                "description", description,
                "schemaType", schemaType,
                "authentication", authentication,
                "operationDetails", operationDetails);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<String> schemaType = JsonNullable.undefined();

        private JsonNullable<? extends List<AuthenticationMetaItem>> authentication = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> operationDetails = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The action ID
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The action ID
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * The action name
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The action name
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * The action description
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * The action description
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * The schema type for the action
         */
        public Builder schemaType(String schemaType) {
            Utils.checkNotNull(schemaType, "schemaType");
            this.schemaType = JsonNullable.of(schemaType);
            return this;
        }

        /**
         * The schema type for the action
         */
        public Builder schemaType(JsonNullable<String> schemaType) {
            Utils.checkNotNull(schemaType, "schemaType");
            this.schemaType = schemaType;
            return this;
        }


        /**
         * The authentication methods supported by this action
         */
        public Builder authentication(List<AuthenticationMetaItem> authentication) {
            Utils.checkNotNull(authentication, "authentication");
            this.authentication = JsonNullable.of(authentication);
            return this;
        }

        /**
         * The authentication methods supported by this action
         */
        public Builder authentication(JsonNullable<? extends List<AuthenticationMetaItem>> authentication) {
            Utils.checkNotNull(authentication, "authentication");
            this.authentication = authentication;
            return this;
        }


        /**
         * The operation details for the action
         */
        public Builder operationDetails(Map<String, Object> operationDetails) {
            Utils.checkNotNull(operationDetails, "operationDetails");
            this.operationDetails = JsonNullable.of(operationDetails);
            return this;
        }

        /**
         * The operation details for the action
         */
        public Builder operationDetails(JsonNullable<? extends Map<String, Object>> operationDetails) {
            Utils.checkNotNull(operationDetails, "operationDetails");
            this.operationDetails = operationDetails;
            return this;
        }

        public ActionMetaItem build() {

            return new ActionMetaItem(
                id, name, description,
                schemaType, authentication, operationDetails);
        }

    }
}
