/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * IamMfaTypeEnumValue
 * 
 * <p>The unified value for the type of multi-factor authentication. If the provider does not send back a type but does specify that MFA is set-up for this user, the value will be set to 'unknown'.'
 */
@JsonDeserialize(using = IamMfaTypeEnumValue._Deserializer.class)
@JsonSerialize(using = IamMfaTypeEnumValue._Serializer.class)
public class IamMfaTypeEnumValue {

    public static final IamMfaTypeEnumValue SMS = new IamMfaTypeEnumValue("sms");
    public static final IamMfaTypeEnumValue EMAIL = new IamMfaTypeEnumValue("email");
    public static final IamMfaTypeEnumValue PUSH = new IamMfaTypeEnumValue("push");
    public static final IamMfaTypeEnumValue TOTP = new IamMfaTypeEnumValue("totp");
    public static final IamMfaTypeEnumValue PHONE_CALL = new IamMfaTypeEnumValue("phone_call");
    public static final IamMfaTypeEnumValue QUESTION = new IamMfaTypeEnumValue("question");
    public static final IamMfaTypeEnumValue SOFTWARE_TOKEN = new IamMfaTypeEnumValue("software_token");
    public static final IamMfaTypeEnumValue HARDWARE_TOKEN = new IamMfaTypeEnumValue("hardware_token");
    public static final IamMfaTypeEnumValue WEB = new IamMfaTypeEnumValue("web");
    public static final IamMfaTypeEnumValue UNKNOWN = new IamMfaTypeEnumValue("unknown");
    public static final IamMfaTypeEnumValue UNMAPPED_VALUE = new IamMfaTypeEnumValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, IamMfaTypeEnumValue> values = createValuesMap();
    private static final Map<String, IamMfaTypeEnumValueEnum> enums = createEnumsMap();

    private final String value;

    private IamMfaTypeEnumValue(String value) {
        this.value = value;
    }

    /**
     * Returns a IamMfaTypeEnumValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as IamMfaTypeEnumValue
     */ 
    public static IamMfaTypeEnumValue of(String value) {
        synchronized (IamMfaTypeEnumValue.class) {
            return values.computeIfAbsent(value, v -> new IamMfaTypeEnumValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<IamMfaTypeEnumValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        IamMfaTypeEnumValue other = (IamMfaTypeEnumValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "IamMfaTypeEnumValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static IamMfaTypeEnumValue[] values() {
        synchronized (IamMfaTypeEnumValue.class) {
            return values.values().toArray(new IamMfaTypeEnumValue[] {});
        }
    }

    private static final Map<String, IamMfaTypeEnumValue> createValuesMap() {
        Map<String, IamMfaTypeEnumValue> map = new LinkedHashMap<>();
        map.put("sms", SMS);
        map.put("email", EMAIL);
        map.put("push", PUSH);
        map.put("totp", TOTP);
        map.put("phone_call", PHONE_CALL);
        map.put("question", QUESTION);
        map.put("software_token", SOFTWARE_TOKEN);
        map.put("hardware_token", HARDWARE_TOKEN);
        map.put("web", WEB);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, IamMfaTypeEnumValueEnum> createEnumsMap() {
        Map<String, IamMfaTypeEnumValueEnum> map = new HashMap<>();
        map.put("sms", IamMfaTypeEnumValueEnum.SMS);
        map.put("email", IamMfaTypeEnumValueEnum.EMAIL);
        map.put("push", IamMfaTypeEnumValueEnum.PUSH);
        map.put("totp", IamMfaTypeEnumValueEnum.TOTP);
        map.put("phone_call", IamMfaTypeEnumValueEnum.PHONE_CALL);
        map.put("question", IamMfaTypeEnumValueEnum.QUESTION);
        map.put("software_token", IamMfaTypeEnumValueEnum.SOFTWARE_TOKEN);
        map.put("hardware_token", IamMfaTypeEnumValueEnum.HARDWARE_TOKEN);
        map.put("web", IamMfaTypeEnumValueEnum.WEB);
        map.put("unknown", IamMfaTypeEnumValueEnum.UNKNOWN);
        map.put("unmapped_value", IamMfaTypeEnumValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<IamMfaTypeEnumValue> {

        protected _Serializer() {
            super(IamMfaTypeEnumValue.class);
        }

        @Override
        public void serialize(IamMfaTypeEnumValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<IamMfaTypeEnumValue> {

        protected _Deserializer() {
            super(IamMfaTypeEnumValue.class);
        }

        @Override
        public IamMfaTypeEnumValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return IamMfaTypeEnumValue.of(v);
        }
    }
    
    public enum IamMfaTypeEnumValueEnum {

        SMS("sms"),
        EMAIL("email"),
        PUSH("push"),
        TOTP("totp"),
        PHONE_CALL("phone_call"),
        QUESTION("question"),
        SOFTWARE_TOKEN("software_token"),
        HARDWARE_TOKEN("hardware_token"),
        WEB("web"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private IamMfaTypeEnumValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

