/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class StackoneMcpGetRequest {
    /**
     * Account secure id for the target provider account
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Session id
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=mcp-session-id")
    private String mcpSessionId;

    @JsonCreator
    public StackoneMcpGetRequest(
            String xAccountId,
            String mcpSessionId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.xAccountId = xAccountId;
        this.mcpSessionId = mcpSessionId;
    }

    /**
     * Account secure id for the target provider account
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Session id
     */
    @JsonIgnore
    public String mcpSessionId() {
        return mcpSessionId;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Account secure id for the target provider account
     */
    public StackoneMcpGetRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Session id
     */
    public StackoneMcpGetRequest withMcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneMcpGetRequest other = (StackoneMcpGetRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.mcpSessionId, other.mcpSessionId);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, mcpSessionId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneMcpGetRequest.class,
                "xAccountId", xAccountId,
                "mcpSessionId", mcpSessionId);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String mcpSessionId;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Account secure id for the target provider account
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Session id
         */
        public Builder mcpSessionId(String mcpSessionId) {
            Utils.checkNotNull(mcpSessionId, "mcpSessionId");
            this.mcpSessionId = mcpSessionId;
            return this;
        }

        public StackoneMcpGetRequest build() {

            return new StackoneMcpGetRequest(
                xAccountId, mcpSessionId);
        }

    }
}
