/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;
import static com.stackone.stackone_client_java.utils.reactive.ReactiveUtils.mapAsync;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AtsListApplicationsRequest;
import com.stackone.stackone_client_java.operations.AtsListApplications;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import java.lang.Exception;
import java.lang.String;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class AtsListApplicationsRequestBuilder {

    private AtsListApplicationsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AtsListApplicationsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsListApplicationsRequestBuilder request(AtsListApplicationsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }
                
    public AtsListApplicationsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListApplicationsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<AtsListApplicationsResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<AtsListApplicationsRequest, AtsListApplicationsResponse> operation
              = new AtsListApplications.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

    /**
     * Returns a Publisher that performs next page calls till no more pages
     * are returned.
     *
     * <p>The returned publisher can be used with reactive frameworks:
     * <pre><code>
     * Publisher&lt;AtsListApplicationsResponse&gt; publisher = builder.callAsPublisher();
     * publisher.subscribe(new Subscriber&lt;AtsListApplicationsResponse&gt;() {
     *     // Handle onNext, onError, onComplete
     * });
     * </code></pre>
     *
     * @return A Publisher that emits pages asynchronously
     */
    public Publisher<AtsListApplicationsResponse> callAsPublisher() {
        AtsListApplicationsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<AtsListApplicationsRequest, AtsListApplicationsResponse> operation
              = new AtsListApplications.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());

        Flow.Publisher<HttpResponse<Blob>> asyncPaginator = new AsyncPaginator<>(
            request,
            new CursorTracker<>("$.next", String.class),
                    AtsListApplicationsRequest::withNext,
            operation::doRequest);

        Flow.Publisher<AtsListApplicationsResponse> flowPublisher = mapAsync(asyncPaginator, operation::handleResponse);

        // Convert Flow.Publisher to Reactive Streams Publisher at the last stage
        return FlowAdapters.toPublisher(flowPublisher);
    }

}
