/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CustomFieldDefinitionsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class HrisListEmployeeCustomFieldDefinitionsResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The list of employee custom field definitions was retrieved.
     */
    private Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated;


    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListEmployeeCustomFieldDefinitionsResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.customFieldDefinitionsPaginated = customFieldDefinitionsPaginated;
        this.headers = headers;
    }
    
    public HrisListEmployeeCustomFieldDefinitionsResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The list of employee custom field definitions was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated() {
        return (Optional<CustomFieldDefinitionsPaginated>) customFieldDefinitionsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public HrisListEmployeeCustomFieldDefinitionsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public HrisListEmployeeCustomFieldDefinitionsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public HrisListEmployeeCustomFieldDefinitionsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The list of employee custom field definitions was retrieved.
     */
    public HrisListEmployeeCustomFieldDefinitionsResponse withCustomFieldDefinitionsPaginated(CustomFieldDefinitionsPaginated customFieldDefinitionsPaginated) {
        Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
        this.customFieldDefinitionsPaginated = Optional.ofNullable(customFieldDefinitionsPaginated);
        return this;
    }


    /**
     * The list of employee custom field definitions was retrieved.
     */
    public HrisListEmployeeCustomFieldDefinitionsResponse withCustomFieldDefinitionsPaginated(Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated) {
        Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
        this.customFieldDefinitionsPaginated = customFieldDefinitionsPaginated;
        return this;
    }

    public HrisListEmployeeCustomFieldDefinitionsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeCustomFieldDefinitionsResponse other = (HrisListEmployeeCustomFieldDefinitionsResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.customFieldDefinitionsPaginated, other.customFieldDefinitionsPaginated) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            customFieldDefinitionsPaginated, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisListEmployeeCustomFieldDefinitionsResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "customFieldDefinitionsPaginated", customFieldDefinitionsPaginated,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The list of employee custom field definitions was retrieved.
         */
        public Builder customFieldDefinitionsPaginated(CustomFieldDefinitionsPaginated customFieldDefinitionsPaginated) {
            Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
            this.customFieldDefinitionsPaginated = Optional.ofNullable(customFieldDefinitionsPaginated);
            return this;
        }

        /**
         * The list of employee custom field definitions was retrieved.
         */
        public Builder customFieldDefinitionsPaginated(Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated) {
            Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
            this.customFieldDefinitionsPaginated = customFieldDefinitionsPaginated;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListEmployeeCustomFieldDefinitionsResponse build() {

            return new HrisListEmployeeCustomFieldDefinitionsResponse(
                contentType, statusCode, rawResponse,
                customFieldDefinitionsPaginated, headers);
        }

    }
}
