/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.HasSecurity;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;

public class SchemeBasic
implements HasSecurity {
    @SpeakeasyMetadata(value="security:name=username")
    private String username;
    @SpeakeasyMetadata(value="security:name=password")
    private String password;

    @JsonCreator
    public SchemeBasic(String username, String password) {
        Utils.checkNotNull(username, "username");
        Utils.checkNotNull(password, "password");
        this.username = username;
        this.password = password;
    }

    @JsonIgnore
    public String username() {
        return this.username;
    }

    @JsonIgnore
    public String password() {
        return this.password;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SchemeBasic withUsername(String username) {
        Utils.checkNotNull(username, "username");
        this.username = username;
        return this;
    }

    public SchemeBasic withPassword(String password) {
        Utils.checkNotNull(password, "password");
        this.password = password;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemeBasic other = (SchemeBasic)o;
        return Utils.enhancedDeepEquals(this.username, other.username) && Utils.enhancedDeepEquals(this.password, other.password);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.username, this.password);
    }

    public String toString() {
        return Utils.toString(SchemeBasic.class, "username", this.username, "password", this.password);
    }

    public static final class Builder {
        private String username;
        private String password;

        private Builder() {
        }

        public Builder username(String username) {
            Utils.checkNotNull(username, "username");
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            Utils.checkNotNull(password, "password");
            this.password = password;
            return this;
        }

        public SchemeBasic build() {
            return new SchemeBasic(this.username, this.password);
        }
    }
}

