/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneListActionsMetaRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListActionsMetaResponse;
import com.stackone.stackone_client_java.operations.StackoneListActionsMeta;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class StackoneListActionsMetaRequestBuilder {
    private StackoneListActionsMetaRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public StackoneListActionsMetaRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneListActionsMetaRequestBuilder request(StackoneListActionsMetaRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public StackoneListActionsMetaRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneListActionsMetaRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public StackoneListActionsMetaResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneListActionsMeta.Sync operation = new StackoneListActionsMeta.Sync(this.sdkConfiguration, options);
        return (StackoneListActionsMetaResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<StackoneListActionsMetaResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneListActionsMeta.Sync operation = new StackoneListActionsMeta.Sync(this.sdkConfiguration, options);
        Paginator<StackoneListActionsMetaRequest, String> iterator = new Paginator<StackoneListActionsMetaRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), StackoneListActionsMetaRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<StackoneListActionsMetaResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

