/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TimeOffResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetTimeOffRequestResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends TimeOffResult> timeOffResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetTimeOffRequestResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends TimeOffResult> timeOffResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(timeOffResult, "timeOffResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.timeOffResult = timeOffResult;
        this.headers = headers;
    }

    public HrisGetTimeOffRequestResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TimeOffResult> timeOffResult() {
        return this.timeOffResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisGetTimeOffRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetTimeOffRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetTimeOffRequestResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetTimeOffRequestResponse withTimeOffResult(TimeOffResult timeOffResult) {
        Utils.checkNotNull(timeOffResult, "timeOffResult");
        this.timeOffResult = Optional.ofNullable(timeOffResult);
        return this;
    }

    public HrisGetTimeOffRequestResponse withTimeOffResult(Optional<? extends TimeOffResult> timeOffResult) {
        Utils.checkNotNull(timeOffResult, "timeOffResult");
        this.timeOffResult = timeOffResult;
        return this;
    }

    public HrisGetTimeOffRequestResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetTimeOffRequestResponse other = (HrisGetTimeOffRequestResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.timeOffResult, other.timeOffResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.timeOffResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetTimeOffRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "timeOffResult", this.timeOffResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends TimeOffResult> timeOffResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder timeOffResult(TimeOffResult timeOffResult) {
            Utils.checkNotNull(timeOffResult, "timeOffResult");
            this.timeOffResult = Optional.ofNullable(timeOffResult);
            return this;
        }

        public Builder timeOffResult(Optional<? extends TimeOffResult> timeOffResult) {
            Utils.checkNotNull(timeOffResult, "timeOffResult");
            this.timeOffResult = timeOffResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetTimeOffRequestResponse build() {
            return new HrisGetTimeOffRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.timeOffResult, this.headers);
        }
    }
}

