/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.PushTemplateResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingGetPushTemplateResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends PushTemplateResult> pushTemplateResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingGetPushTemplateResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends PushTemplateResult> pushTemplateResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(pushTemplateResult, "pushTemplateResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.pushTemplateResult = pushTemplateResult;
        this.headers = headers;
    }

    public MarketingGetPushTemplateResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<PushTemplateResult> pushTemplateResult() {
        return this.pushTemplateResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MarketingGetPushTemplateResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingGetPushTemplateResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingGetPushTemplateResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingGetPushTemplateResponse withPushTemplateResult(PushTemplateResult pushTemplateResult) {
        Utils.checkNotNull(pushTemplateResult, "pushTemplateResult");
        this.pushTemplateResult = Optional.ofNullable(pushTemplateResult);
        return this;
    }

    public MarketingGetPushTemplateResponse withPushTemplateResult(Optional<? extends PushTemplateResult> pushTemplateResult) {
        Utils.checkNotNull(pushTemplateResult, "pushTemplateResult");
        this.pushTemplateResult = pushTemplateResult;
        return this;
    }

    public MarketingGetPushTemplateResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingGetPushTemplateResponse other = (MarketingGetPushTemplateResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.pushTemplateResult, other.pushTemplateResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.pushTemplateResult, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingGetPushTemplateResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "pushTemplateResult", this.pushTemplateResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends PushTemplateResult> pushTemplateResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder pushTemplateResult(PushTemplateResult pushTemplateResult) {
            Utils.checkNotNull(pushTemplateResult, "pushTemplateResult");
            this.pushTemplateResult = Optional.ofNullable(pushTemplateResult);
            return this;
        }

        public Builder pushTemplateResult(Optional<? extends PushTemplateResult> pushTemplateResult) {
            Utils.checkNotNull(pushTemplateResult, "pushTemplateResult");
            this.pushTemplateResult = pushTemplateResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MarketingGetPushTemplateResponse build() {
            return new MarketingGetPushTemplateResponse(this.contentType, this.statusCode, this.rawResponse, this.pushTemplateResult, this.headers);
        }
    }
}

