/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingUserResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MessagingGetUserResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends MessagingUserResult> messagingUserResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MessagingGetUserResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends MessagingUserResult> messagingUserResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(messagingUserResult, "messagingUserResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.messagingUserResult = messagingUserResult;
        this.headers = headers;
    }

    public MessagingGetUserResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<MessagingUserResult> messagingUserResult() {
        return this.messagingUserResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessagingGetUserResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MessagingGetUserResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MessagingGetUserResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MessagingGetUserResponse withMessagingUserResult(MessagingUserResult messagingUserResult) {
        Utils.checkNotNull(messagingUserResult, "messagingUserResult");
        this.messagingUserResult = Optional.ofNullable(messagingUserResult);
        return this;
    }

    public MessagingGetUserResponse withMessagingUserResult(Optional<? extends MessagingUserResult> messagingUserResult) {
        Utils.checkNotNull(messagingUserResult, "messagingUserResult");
        this.messagingUserResult = messagingUserResult;
        return this;
    }

    public MessagingGetUserResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingGetUserResponse other = (MessagingGetUserResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.messagingUserResult, other.messagingUserResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.messagingUserResult, this.headers);
    }

    public String toString() {
        return Utils.toString(MessagingGetUserResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "messagingUserResult", this.messagingUserResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends MessagingUserResult> messagingUserResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder messagingUserResult(MessagingUserResult messagingUserResult) {
            Utils.checkNotNull(messagingUserResult, "messagingUserResult");
            this.messagingUserResult = Optional.ofNullable(messagingUserResult);
            return this;
        }

        public Builder messagingUserResult(Optional<? extends MessagingUserResult> messagingUserResult) {
            Utils.checkNotNull(messagingUserResult, "messagingUserResult");
            this.messagingUserResult = messagingUserResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MessagingGetUserResponse build() {
            return new MessagingGetUserResponse(this.contentType, this.statusCode, this.rawResponse, this.messagingUserResult, this.headers);
        }
    }
}

