/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CompaniesPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListCompaniesGroupsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends CompaniesPaginated> companiesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListCompaniesGroupsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends CompaniesPaginated> companiesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(companiesPaginated, "companiesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.companiesPaginated = companiesPaginated;
        this.headers = headers;
    }

    public HrisListCompaniesGroupsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CompaniesPaginated> companiesPaginated() {
        return this.companiesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListCompaniesGroupsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListCompaniesGroupsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListCompaniesGroupsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListCompaniesGroupsResponse withCompaniesPaginated(CompaniesPaginated companiesPaginated) {
        Utils.checkNotNull(companiesPaginated, "companiesPaginated");
        this.companiesPaginated = Optional.ofNullable(companiesPaginated);
        return this;
    }

    public HrisListCompaniesGroupsResponse withCompaniesPaginated(Optional<? extends CompaniesPaginated> companiesPaginated) {
        Utils.checkNotNull(companiesPaginated, "companiesPaginated");
        this.companiesPaginated = companiesPaginated;
        return this;
    }

    public HrisListCompaniesGroupsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListCompaniesGroupsResponse other = (HrisListCompaniesGroupsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.companiesPaginated, other.companiesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.companiesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListCompaniesGroupsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "companiesPaginated", this.companiesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends CompaniesPaginated> companiesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder companiesPaginated(CompaniesPaginated companiesPaginated) {
            Utils.checkNotNull(companiesPaginated, "companiesPaginated");
            this.companiesPaginated = Optional.ofNullable(companiesPaginated);
            return this;
        }

        public Builder companiesPaginated(Optional<? extends CompaniesPaginated> companiesPaginated) {
            Utils.checkNotNull(companiesPaginated, "companiesPaginated");
            this.companiesPaginated = companiesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListCompaniesGroupsResponse build() {
            return new HrisListCompaniesGroupsResponse(this.contentType, this.statusCode, this.rawResponse, this.companiesPaginated, this.headers);
        }
    }
}

