/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class MessagingMessageResultData {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Content of the message
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content")
    private JsonNullable<? extends MessagingMessageResultContent> content;

    /**
     * ID of the parent message if this is a reply
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parent_message_id")
    private JsonNullable<String> parentMessageId;

    /**
     * List of attachments in the message
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("attachments")
    private JsonNullable<? extends List<MessagingAttachment>> attachments;

    /**
     * Author of the message
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("author")
    private JsonNullable<? extends MessagingMessageResultAuthor> author;

    /**
     * Timestamp when the message was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * Timestamp when the message was last updated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public MessagingMessageResultData(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("content") JsonNullable<? extends MessagingMessageResultContent> content,
            @JsonProperty("parent_message_id") JsonNullable<String> parentMessageId,
            @JsonProperty("attachments") JsonNullable<? extends List<MessagingAttachment>> attachments,
            @JsonProperty("author") JsonNullable<? extends MessagingMessageResultAuthor> author,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(parentMessageId, "parentMessageId");
        Utils.checkNotNull(attachments, "attachments");
        Utils.checkNotNull(author, "author");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.content = content;
        this.parentMessageId = parentMessageId;
        this.attachments = attachments;
        this.author = author;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public MessagingMessageResultData() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Content of the message
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<MessagingMessageResultContent> content() {
        return (JsonNullable<MessagingMessageResultContent>) content;
    }

    /**
     * ID of the parent message if this is a reply
     */
    @JsonIgnore
    public JsonNullable<String> parentMessageId() {
        return parentMessageId;
    }

    /**
     * List of attachments in the message
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<MessagingAttachment>> attachments() {
        return (JsonNullable<List<MessagingAttachment>>) attachments;
    }

    /**
     * Author of the message
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<MessagingMessageResultAuthor> author() {
        return (JsonNullable<MessagingMessageResultAuthor>) author;
    }

    /**
     * Timestamp when the message was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * Timestamp when the message was last updated
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public MessagingMessageResultData withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public MessagingMessageResultData withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public MessagingMessageResultData withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public MessagingMessageResultData withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Content of the message
     */
    public MessagingMessageResultData withContent(MessagingMessageResultContent content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of(content);
        return this;
    }

    /**
     * Content of the message
     */
    public MessagingMessageResultData withContent(JsonNullable<? extends MessagingMessageResultContent> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * ID of the parent message if this is a reply
     */
    public MessagingMessageResultData withParentMessageId(String parentMessageId) {
        Utils.checkNotNull(parentMessageId, "parentMessageId");
        this.parentMessageId = JsonNullable.of(parentMessageId);
        return this;
    }

    /**
     * ID of the parent message if this is a reply
     */
    public MessagingMessageResultData withParentMessageId(JsonNullable<String> parentMessageId) {
        Utils.checkNotNull(parentMessageId, "parentMessageId");
        this.parentMessageId = parentMessageId;
        return this;
    }

    /**
     * List of attachments in the message
     */
    public MessagingMessageResultData withAttachments(List<MessagingAttachment> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = JsonNullable.of(attachments);
        return this;
    }

    /**
     * List of attachments in the message
     */
    public MessagingMessageResultData withAttachments(JsonNullable<? extends List<MessagingAttachment>> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = attachments;
        return this;
    }

    /**
     * Author of the message
     */
    public MessagingMessageResultData withAuthor(MessagingMessageResultAuthor author) {
        Utils.checkNotNull(author, "author");
        this.author = JsonNullable.of(author);
        return this;
    }

    /**
     * Author of the message
     */
    public MessagingMessageResultData withAuthor(JsonNullable<? extends MessagingMessageResultAuthor> author) {
        Utils.checkNotNull(author, "author");
        this.author = author;
        return this;
    }

    /**
     * Timestamp when the message was created
     */
    public MessagingMessageResultData withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * Timestamp when the message was created
     */
    public MessagingMessageResultData withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Timestamp when the message was last updated
     */
    public MessagingMessageResultData withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * Timestamp when the message was last updated
     */
    public MessagingMessageResultData withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingMessageResultData other = (MessagingMessageResultData) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.content, other.content) &&
            Utils.enhancedDeepEquals(this.parentMessageId, other.parentMessageId) &&
            Utils.enhancedDeepEquals(this.attachments, other.attachments) &&
            Utils.enhancedDeepEquals(this.author, other.author) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, content,
            parentMessageId, attachments, author,
            createdAt, updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingMessageResultData.class,
                "id", id,
                "remoteId", remoteId,
                "content", content,
                "parentMessageId", parentMessageId,
                "attachments", attachments,
                "author", author,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends MessagingMessageResultContent> content = JsonNullable.undefined();

        private JsonNullable<String> parentMessageId = JsonNullable.undefined();

        private JsonNullable<? extends List<MessagingAttachment>> attachments = JsonNullable.undefined();

        private JsonNullable<? extends MessagingMessageResultAuthor> author = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Content of the message
         */
        public Builder content(MessagingMessageResultContent content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of(content);
            return this;
        }

        /**
         * Content of the message
         */
        public Builder content(JsonNullable<? extends MessagingMessageResultContent> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }


        /**
         * ID of the parent message if this is a reply
         */
        public Builder parentMessageId(String parentMessageId) {
            Utils.checkNotNull(parentMessageId, "parentMessageId");
            this.parentMessageId = JsonNullable.of(parentMessageId);
            return this;
        }

        /**
         * ID of the parent message if this is a reply
         */
        public Builder parentMessageId(JsonNullable<String> parentMessageId) {
            Utils.checkNotNull(parentMessageId, "parentMessageId");
            this.parentMessageId = parentMessageId;
            return this;
        }


        /**
         * List of attachments in the message
         */
        public Builder attachments(List<MessagingAttachment> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = JsonNullable.of(attachments);
            return this;
        }

        /**
         * List of attachments in the message
         */
        public Builder attachments(JsonNullable<? extends List<MessagingAttachment>> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = attachments;
            return this;
        }


        /**
         * Author of the message
         */
        public Builder author(MessagingMessageResultAuthor author) {
            Utils.checkNotNull(author, "author");
            this.author = JsonNullable.of(author);
            return this;
        }

        /**
         * Author of the message
         */
        public Builder author(JsonNullable<? extends MessagingMessageResultAuthor> author) {
            Utils.checkNotNull(author, "author");
            this.author = author;
            return this;
        }


        /**
         * Timestamp when the message was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * Timestamp when the message was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * Timestamp when the message was last updated
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * Timestamp when the message was last updated
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public MessagingMessageResultData build() {

            return new MessagingMessageResultData(
                id, remoteId, content,
                parentMessageId, attachments, author,
                createdAt, updatedAt);
        }

    }
}
