/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;


public class TaskCommentApiModel {
    /**
     * The Employee ID of the author of the comment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("author_employee_id")
    private JsonNullable<String> authorEmployeeId;

    /**
     * The text of the comment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("comment")
    private JsonNullable<String> comment;

    /**
     * The creation date of this comment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    @JsonCreator
    public TaskCommentApiModel(
            @JsonProperty("author_employee_id") JsonNullable<String> authorEmployeeId,
            @JsonProperty("comment") JsonNullable<String> comment,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(authorEmployeeId, "authorEmployeeId");
        Utils.checkNotNull(comment, "comment");
        Utils.checkNotNull(createdAt, "createdAt");
        this.authorEmployeeId = authorEmployeeId;
        this.comment = comment;
        this.createdAt = createdAt;
    }
    
    public TaskCommentApiModel() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The Employee ID of the author of the comment
     */
    @JsonIgnore
    public JsonNullable<String> authorEmployeeId() {
        return authorEmployeeId;
    }

    /**
     * The text of the comment
     */
    @JsonIgnore
    public JsonNullable<String> comment() {
        return comment;
    }

    /**
     * The creation date of this comment
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The Employee ID of the author of the comment
     */
    public TaskCommentApiModel withAuthorEmployeeId(String authorEmployeeId) {
        Utils.checkNotNull(authorEmployeeId, "authorEmployeeId");
        this.authorEmployeeId = JsonNullable.of(authorEmployeeId);
        return this;
    }

    /**
     * The Employee ID of the author of the comment
     */
    public TaskCommentApiModel withAuthorEmployeeId(JsonNullable<String> authorEmployeeId) {
        Utils.checkNotNull(authorEmployeeId, "authorEmployeeId");
        this.authorEmployeeId = authorEmployeeId;
        return this;
    }

    /**
     * The text of the comment
     */
    public TaskCommentApiModel withComment(String comment) {
        Utils.checkNotNull(comment, "comment");
        this.comment = JsonNullable.of(comment);
        return this;
    }

    /**
     * The text of the comment
     */
    public TaskCommentApiModel withComment(JsonNullable<String> comment) {
        Utils.checkNotNull(comment, "comment");
        this.comment = comment;
        return this;
    }

    /**
     * The creation date of this comment
     */
    public TaskCommentApiModel withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The creation date of this comment
     */
    public TaskCommentApiModel withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaskCommentApiModel other = (TaskCommentApiModel) o;
        return 
            Utils.enhancedDeepEquals(this.authorEmployeeId, other.authorEmployeeId) &&
            Utils.enhancedDeepEquals(this.comment, other.comment) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            authorEmployeeId, comment, createdAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TaskCommentApiModel.class,
                "authorEmployeeId", authorEmployeeId,
                "comment", comment,
                "createdAt", createdAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> authorEmployeeId = JsonNullable.undefined();

        private JsonNullable<String> comment = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The Employee ID of the author of the comment
         */
        public Builder authorEmployeeId(String authorEmployeeId) {
            Utils.checkNotNull(authorEmployeeId, "authorEmployeeId");
            this.authorEmployeeId = JsonNullable.of(authorEmployeeId);
            return this;
        }

        /**
         * The Employee ID of the author of the comment
         */
        public Builder authorEmployeeId(JsonNullable<String> authorEmployeeId) {
            Utils.checkNotNull(authorEmployeeId, "authorEmployeeId");
            this.authorEmployeeId = authorEmployeeId;
            return this;
        }


        /**
         * The text of the comment
         */
        public Builder comment(String comment) {
            Utils.checkNotNull(comment, "comment");
            this.comment = JsonNullable.of(comment);
            return this;
        }

        /**
         * The text of the comment
         */
        public Builder comment(JsonNullable<String> comment) {
            Utils.checkNotNull(comment, "comment");
            this.comment = comment;
            return this;
        }


        /**
         * The creation date of this comment
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The creation date of this comment
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public TaskCommentApiModel build() {

            return new TaskCommentApiModel(
                authorEmployeeId, comment, createdAt);
        }

    }
}
