/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;


public class TicketingUserResultData {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends TicketingUserResultType> type;

    /**
     * John Doe
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The user's primary email address
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("primary_email")
    private JsonNullable<String> primaryEmail;

    /**
     * The user's primary phone number
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("primary_phone")
    private JsonNullable<String> primaryPhone;

    /**
     * The username of the user in the provider system
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("username")
    private JsonNullable<String> username;

    /**
     * If the user is active
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("active")
    private JsonNullable<? extends TicketingUserResultActive> active;

    /**
     * The first name of the user
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("first_name")
    private JsonNullable<String> firstName;

    /**
     * The last name of the user
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("last_name")
    private JsonNullable<String> lastName;

    /**
     * The unique account reference assigned as an external user (e.g. the customer account identifier
     * registered on the customer-facing site or portal)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("customer_account_reference")
    private JsonNullable<String> customerAccountReference;

    /**
     * The timestamp when the record was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The timestamp when the record was last updated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public TicketingUserResultData(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("type") JsonNullable<? extends TicketingUserResultType> type,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("primary_email") JsonNullable<String> primaryEmail,
            @JsonProperty("primary_phone") JsonNullable<String> primaryPhone,
            @JsonProperty("username") JsonNullable<String> username,
            @JsonProperty("active") JsonNullable<? extends TicketingUserResultActive> active,
            @JsonProperty("first_name") JsonNullable<String> firstName,
            @JsonProperty("last_name") JsonNullable<String> lastName,
            @JsonProperty("customer_account_reference") JsonNullable<String> customerAccountReference,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(primaryEmail, "primaryEmail");
        Utils.checkNotNull(primaryPhone, "primaryPhone");
        Utils.checkNotNull(username, "username");
        Utils.checkNotNull(active, "active");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(customerAccountReference, "customerAccountReference");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.type = type;
        this.name = name;
        this.primaryEmail = primaryEmail;
        this.primaryPhone = primaryPhone;
        this.username = username;
        this.active = active;
        this.firstName = firstName;
        this.lastName = lastName;
        this.customerAccountReference = customerAccountReference;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public TicketingUserResultData() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TicketingUserResultType> type() {
        return (JsonNullable<TicketingUserResultType>) type;
    }

    /**
     * John Doe
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The user's primary email address
     */
    @JsonIgnore
    public JsonNullable<String> primaryEmail() {
        return primaryEmail;
    }

    /**
     * The user's primary phone number
     */
    @JsonIgnore
    public JsonNullable<String> primaryPhone() {
        return primaryPhone;
    }

    /**
     * The username of the user in the provider system
     */
    @JsonIgnore
    public JsonNullable<String> username() {
        return username;
    }

    /**
     * If the user is active
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TicketingUserResultActive> active() {
        return (JsonNullable<TicketingUserResultActive>) active;
    }

    /**
     * The first name of the user
     */
    @JsonIgnore
    public JsonNullable<String> firstName() {
        return firstName;
    }

    /**
     * The last name of the user
     */
    @JsonIgnore
    public JsonNullable<String> lastName() {
        return lastName;
    }

    /**
     * The unique account reference assigned as an external user (e.g. the customer account identifier
     * registered on the customer-facing site or portal)
     */
    @JsonIgnore
    public JsonNullable<String> customerAccountReference() {
        return customerAccountReference;
    }

    /**
     * The timestamp when the record was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The timestamp when the record was last updated
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public TicketingUserResultData withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public TicketingUserResultData withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TicketingUserResultData withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TicketingUserResultData withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public TicketingUserResultData withType(TicketingUserResultType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    public TicketingUserResultData withType(JsonNullable<? extends TicketingUserResultType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * John Doe
     */
    public TicketingUserResultData withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * John Doe
     */
    public TicketingUserResultData withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The user's primary email address
     */
    public TicketingUserResultData withPrimaryEmail(String primaryEmail) {
        Utils.checkNotNull(primaryEmail, "primaryEmail");
        this.primaryEmail = JsonNullable.of(primaryEmail);
        return this;
    }

    /**
     * The user's primary email address
     */
    public TicketingUserResultData withPrimaryEmail(JsonNullable<String> primaryEmail) {
        Utils.checkNotNull(primaryEmail, "primaryEmail");
        this.primaryEmail = primaryEmail;
        return this;
    }

    /**
     * The user's primary phone number
     */
    public TicketingUserResultData withPrimaryPhone(String primaryPhone) {
        Utils.checkNotNull(primaryPhone, "primaryPhone");
        this.primaryPhone = JsonNullable.of(primaryPhone);
        return this;
    }

    /**
     * The user's primary phone number
     */
    public TicketingUserResultData withPrimaryPhone(JsonNullable<String> primaryPhone) {
        Utils.checkNotNull(primaryPhone, "primaryPhone");
        this.primaryPhone = primaryPhone;
        return this;
    }

    /**
     * The username of the user in the provider system
     */
    public TicketingUserResultData withUsername(String username) {
        Utils.checkNotNull(username, "username");
        this.username = JsonNullable.of(username);
        return this;
    }

    /**
     * The username of the user in the provider system
     */
    public TicketingUserResultData withUsername(JsonNullable<String> username) {
        Utils.checkNotNull(username, "username");
        this.username = username;
        return this;
    }

    /**
     * If the user is active
     */
    public TicketingUserResultData withActive(TicketingUserResultActive active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * If the user is active
     */
    public TicketingUserResultData withActive(JsonNullable<? extends TicketingUserResultActive> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    /**
     * The first name of the user
     */
    public TicketingUserResultData withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = JsonNullable.of(firstName);
        return this;
    }

    /**
     * The first name of the user
     */
    public TicketingUserResultData withFirstName(JsonNullable<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    /**
     * The last name of the user
     */
    public TicketingUserResultData withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = JsonNullable.of(lastName);
        return this;
    }

    /**
     * The last name of the user
     */
    public TicketingUserResultData withLastName(JsonNullable<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    /**
     * The unique account reference assigned as an external user (e.g. the customer account identifier
     * registered on the customer-facing site or portal)
     */
    public TicketingUserResultData withCustomerAccountReference(String customerAccountReference) {
        Utils.checkNotNull(customerAccountReference, "customerAccountReference");
        this.customerAccountReference = JsonNullable.of(customerAccountReference);
        return this;
    }

    /**
     * The unique account reference assigned as an external user (e.g. the customer account identifier
     * registered on the customer-facing site or portal)
     */
    public TicketingUserResultData withCustomerAccountReference(JsonNullable<String> customerAccountReference) {
        Utils.checkNotNull(customerAccountReference, "customerAccountReference");
        this.customerAccountReference = customerAccountReference;
        return this;
    }

    /**
     * The timestamp when the record was created
     */
    public TicketingUserResultData withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The timestamp when the record was created
     */
    public TicketingUserResultData withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The timestamp when the record was last updated
     */
    public TicketingUserResultData withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The timestamp when the record was last updated
     */
    public TicketingUserResultData withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketingUserResultData other = (TicketingUserResultData) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.primaryEmail, other.primaryEmail) &&
            Utils.enhancedDeepEquals(this.primaryPhone, other.primaryPhone) &&
            Utils.enhancedDeepEquals(this.username, other.username) &&
            Utils.enhancedDeepEquals(this.active, other.active) &&
            Utils.enhancedDeepEquals(this.firstName, other.firstName) &&
            Utils.enhancedDeepEquals(this.lastName, other.lastName) &&
            Utils.enhancedDeepEquals(this.customerAccountReference, other.customerAccountReference) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, type,
            name, primaryEmail, primaryPhone,
            username, active, firstName,
            lastName, customerAccountReference, createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketingUserResultData.class,
                "id", id,
                "remoteId", remoteId,
                "type", type,
                "name", name,
                "primaryEmail", primaryEmail,
                "primaryPhone", primaryPhone,
                "username", username,
                "active", active,
                "firstName", firstName,
                "lastName", lastName,
                "customerAccountReference", customerAccountReference,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends TicketingUserResultType> type = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> primaryEmail = JsonNullable.undefined();

        private JsonNullable<String> primaryPhone = JsonNullable.undefined();

        private JsonNullable<String> username = JsonNullable.undefined();

        private JsonNullable<? extends TicketingUserResultActive> active = JsonNullable.undefined();

        private JsonNullable<String> firstName = JsonNullable.undefined();

        private JsonNullable<String> lastName = JsonNullable.undefined();

        private JsonNullable<String> customerAccountReference = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        public Builder type(TicketingUserResultType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        public Builder type(JsonNullable<? extends TicketingUserResultType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * John Doe
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * John Doe
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * The user's primary email address
         */
        public Builder primaryEmail(String primaryEmail) {
            Utils.checkNotNull(primaryEmail, "primaryEmail");
            this.primaryEmail = JsonNullable.of(primaryEmail);
            return this;
        }

        /**
         * The user's primary email address
         */
        public Builder primaryEmail(JsonNullable<String> primaryEmail) {
            Utils.checkNotNull(primaryEmail, "primaryEmail");
            this.primaryEmail = primaryEmail;
            return this;
        }


        /**
         * The user's primary phone number
         */
        public Builder primaryPhone(String primaryPhone) {
            Utils.checkNotNull(primaryPhone, "primaryPhone");
            this.primaryPhone = JsonNullable.of(primaryPhone);
            return this;
        }

        /**
         * The user's primary phone number
         */
        public Builder primaryPhone(JsonNullable<String> primaryPhone) {
            Utils.checkNotNull(primaryPhone, "primaryPhone");
            this.primaryPhone = primaryPhone;
            return this;
        }


        /**
         * The username of the user in the provider system
         */
        public Builder username(String username) {
            Utils.checkNotNull(username, "username");
            this.username = JsonNullable.of(username);
            return this;
        }

        /**
         * The username of the user in the provider system
         */
        public Builder username(JsonNullable<String> username) {
            Utils.checkNotNull(username, "username");
            this.username = username;
            return this;
        }


        /**
         * If the user is active
         */
        public Builder active(TicketingUserResultActive active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * If the user is active
         */
        public Builder active(JsonNullable<? extends TicketingUserResultActive> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }


        /**
         * The first name of the user
         */
        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = JsonNullable.of(firstName);
            return this;
        }

        /**
         * The first name of the user
         */
        public Builder firstName(JsonNullable<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }


        /**
         * The last name of the user
         */
        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = JsonNullable.of(lastName);
            return this;
        }

        /**
         * The last name of the user
         */
        public Builder lastName(JsonNullable<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }


        /**
         * The unique account reference assigned as an external user (e.g. the customer account identifier
         * registered on the customer-facing site or portal)
         */
        public Builder customerAccountReference(String customerAccountReference) {
            Utils.checkNotNull(customerAccountReference, "customerAccountReference");
            this.customerAccountReference = JsonNullable.of(customerAccountReference);
            return this;
        }

        /**
         * The unique account reference assigned as an external user (e.g. the customer account identifier
         * registered on the customer-facing site or portal)
         */
        public Builder customerAccountReference(JsonNullable<String> customerAccountReference) {
            Utils.checkNotNull(customerAccountReference, "customerAccountReference");
            this.customerAccountReference = customerAccountReference;
            return this;
        }


        /**
         * The timestamp when the record was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The timestamp when the record was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The timestamp when the record was last updated
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The timestamp when the record was last updated
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public TicketingUserResultData build() {

            return new TicketingUserResultData(
                id, remoteId, type,
                name, primaryEmail, primaryPhone,
                username, active, firstName,
                lastName, customerAccountReference, createdAt,
                updatedAt);
        }

    }
}
