/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingUsersPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class MessagingListUsersResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The list of users was retrieved.
     */
    private Optional<? extends MessagingUsersPaginated> messagingUsersPaginated;


    private Map<String, List<String>> headers;

    @JsonCreator
    public MessagingListUsersResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends MessagingUsersPaginated> messagingUsersPaginated,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(messagingUsersPaginated, "messagingUsersPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.messagingUsersPaginated = messagingUsersPaginated;
        this.headers = headers;
    }
    
    public MessagingListUsersResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The list of users was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<MessagingUsersPaginated> messagingUsersPaginated() {
        return (Optional<MessagingUsersPaginated>) messagingUsersPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public MessagingListUsersResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public MessagingListUsersResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public MessagingListUsersResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The list of users was retrieved.
     */
    public MessagingListUsersResponse withMessagingUsersPaginated(MessagingUsersPaginated messagingUsersPaginated) {
        Utils.checkNotNull(messagingUsersPaginated, "messagingUsersPaginated");
        this.messagingUsersPaginated = Optional.ofNullable(messagingUsersPaginated);
        return this;
    }


    /**
     * The list of users was retrieved.
     */
    public MessagingListUsersResponse withMessagingUsersPaginated(Optional<? extends MessagingUsersPaginated> messagingUsersPaginated) {
        Utils.checkNotNull(messagingUsersPaginated, "messagingUsersPaginated");
        this.messagingUsersPaginated = messagingUsersPaginated;
        return this;
    }

    public MessagingListUsersResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingListUsersResponse other = (MessagingListUsersResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.messagingUsersPaginated, other.messagingUsersPaginated) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            messagingUsersPaginated, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingListUsersResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "messagingUsersPaginated", messagingUsersPaginated,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends MessagingUsersPaginated> messagingUsersPaginated = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The list of users was retrieved.
         */
        public Builder messagingUsersPaginated(MessagingUsersPaginated messagingUsersPaginated) {
            Utils.checkNotNull(messagingUsersPaginated, "messagingUsersPaginated");
            this.messagingUsersPaginated = Optional.ofNullable(messagingUsersPaginated);
            return this;
        }

        /**
         * The list of users was retrieved.
         */
        public Builder messagingUsersPaginated(Optional<? extends MessagingUsersPaginated> messagingUsersPaginated) {
            Utils.checkNotNull(messagingUsersPaginated, "messagingUsersPaginated");
            this.messagingUsersPaginated = messagingUsersPaginated;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MessagingListUsersResponse build() {

            return new MessagingListUsersResponse(
                contentType, statusCode, rawResponse,
                messagingUsersPaginated, headers);
        }

    }
}
