/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.TicketingListAttachmentsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListAttachmentsResponse;
import com.stackone.stackone_client_java.operations.TicketingListAttachments;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class TicketingListAttachmentsRequestBuilder {
    private TicketingListAttachmentsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public TicketingListAttachmentsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public TicketingListAttachmentsRequestBuilder request(TicketingListAttachmentsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public TicketingListAttachmentsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public TicketingListAttachmentsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public TicketingListAttachmentsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListAttachments.Sync operation = new TicketingListAttachments.Sync(this.sdkConfiguration, options, this._headers);
        return (TicketingListAttachmentsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<TicketingListAttachmentsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListAttachments.Sync operation = new TicketingListAttachments.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<TicketingListAttachmentsRequest, String> iterator = new Paginator<TicketingListAttachmentsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), TicketingListAttachmentsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<TicketingListAttachmentsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

