/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AtsListUsersRequest;
import com.stackone.stackone_client_java.models.operations.AtsListUsersResponse;
import com.stackone.stackone_client_java.operations.AtsListUsers;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class AtsListUsersRequestBuilder {
    private AtsListUsersRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AtsListUsersRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsListUsersRequestBuilder request(AtsListUsersRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AtsListUsersRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListUsersRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AtsListUsersResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListUsers.Sync operation = new AtsListUsers.Sync(this.sdkConfiguration, options, this._headers);
        return (AtsListUsersResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<AtsListUsersResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListUsers.Sync operation = new AtsListUsers.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<AtsListUsersRequest, String> iterator = new Paginator<AtsListUsersRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), AtsListUsersRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<AtsListUsersResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

